/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;

class PartitionAwareFunctionWrapper
implements Function<Object, Object>,
Supplier<Object> {
    protected final Log logger = LogFactory.getLog(PartitionAwareFunctionWrapper.class);
    private final Function function;
    private final Function<Message, Message> outputMessageEnricher;

    PartitionAwareFunctionWrapper(Function function, ConfigurableApplicationContext context, ProducerProperties producerProperties) {
        this.function = function;
        if (producerProperties != null && producerProperties.isPartitioned()) {
            StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)context.getBeanFactory());
            PartitionHandler partitionHandler = new PartitionHandler((EvaluationContext)evaluationContext, producerProperties, context.getBeanFactory());
            this.outputMessageEnricher = outputMessage -> {
                int partitionId = partitionHandler.determinePartition((Message<?>)outputMessage);
                return MessageBuilder.fromMessage((Message)outputMessage).setHeader("scst_partition", (Object)partitionId).build();
            };
        } else {
            this.outputMessageEnricher = null;
        }
    }

    @Override
    public Object apply(Object input) {
        if (this.function instanceof SimpleFunctionRegistry.FunctionInvocationWrapper && this.outputMessageEnricher != null) {
            try {
                return ((SimpleFunctionRegistry.FunctionInvocationWrapper)this.function).apply(input, this.outputMessageEnricher);
            }
            catch (NoSuchMethodError e) {
                this.logger.warn((Object)"Versions of spring-cloud-function older then 3.0.2.RELEASE do not support generation of partition information. Output message will not contain any partition header unless spring-cloud-function dependency is 3.0.2.RELEASE or higher.");
                return this.function.apply(input);
            }
        }
        return this.function.apply(input);
    }

    @Override
    public Object get() {
        if (this.function instanceof SimpleFunctionRegistry.FunctionInvocationWrapper) {
            if (this.outputMessageEnricher != null) {
                return ((SimpleFunctionRegistry.FunctionInvocationWrapper)this.function).get(this.outputMessageEnricher);
            }
            return ((SimpleFunctionRegistry.FunctionInvocationWrapper)this.function).get();
        }
        throw new IllegalStateException("THis function is not a Supplier. Call to get() is not allowed");
    }
}

