/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.netflix.zuul.web.ZuulHandlerMapping;
import org.springframework.cloud.sleuth.instrument.web.TraceHandlerInterceptor;

class TraceZuulHandlerMappingBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final BeanFactory beanFactory;

    public TraceZuulHandlerMappingBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ZuulHandlerMapping) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attaching trace interceptor to bean [" + beanName + "] of type [" + bean.getClass().getSimpleName() + "]"));
            }
            ZuulHandlerMapping zuulHandlerMapping = (ZuulHandlerMapping)bean;
            zuulHandlerMapping.setInterceptors(new Object[]{new TraceHandlerInterceptor(this.beanFactory)});
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

