/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.methods.RequestBuilder;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.zuul.SpanInjectingRibbonRequestCustomizer;

class ApacheHttpClientRibbonRequestCustomizer
extends SpanInjectingRibbonRequestCustomizer<RequestBuilder> {
    ApacheHttpClientRibbonRequestCustomizer(Tracer tracer) {
        super(tracer);
    }

    public boolean accepts(Class aClass) {
        return aClass == RequestBuilder.class;
    }

    @Override
    protected SpanTextMap toSpanTextMap(final RequestBuilder context) {
        return new SpanTextMap(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                HashMap<String, String> map = new HashMap<String, String>();
                for (Header header : context.build().getAllHeaders()) {
                    map.put(header.getName(), header.getValue());
                }
                return map.entrySet().iterator();
            }

            @Override
            public void put(String key, String value) {
                context.setHeader(key, value);
            }
        };
    }
}

