/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.client.HttpRequestTextMap;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.http.HttpRequest;

abstract class AbstractTraceHttpRequestInterceptor {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected final Tracer tracer;
    protected final HttpSpanInjector spanInjector;
    protected final HttpTraceKeysInjector keysInjector;

    protected AbstractTraceHttpRequestInterceptor(Tracer tracer, HttpSpanInjector spanInjector, HttpTraceKeysInjector keysInjector) {
        this.tracer = tracer;
        this.spanInjector = spanInjector;
        this.keysInjector = keysInjector;
    }

    protected void publishStartEvent(HttpRequest request) {
        URI uri = request.getURI();
        String spanName = this.getName(uri);
        Span newSpan = this.tracer.createSpan(spanName);
        this.spanInjector.inject(newSpan, new HttpRequestTextMap(request));
        this.addRequestTags(request);
        newSpan.logEvent("cs");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting new client span [" + newSpan + "]"));
        }
    }

    private String getName(URI uri) {
        return SpanNameUtil.shorten(this.uriScheme(uri) + ":" + uri.getRawPath());
    }

    private String uriScheme(URI uri) {
        return uri.getScheme() == null ? "http" : uri.getScheme();
    }

    protected void addRequestTags(HttpRequest request) {
        this.keysInjector.addRequestTags(request.getURI().toString(), request.getURI().getHost(), request.getURI().getPath(), request.getMethod().name(), (Map<String, ? extends Collection<String>>)request.getHeaders());
    }

    public void finish() {
        if (!this.isTracing()) {
            return;
        }
        this.currentSpan().logEvent("cr");
        this.tracer.close(this.currentSpan());
    }

    protected Span currentSpan() {
        return this.tracer.getCurrentSpan();
    }

    protected boolean isTracing() {
        return this.tracer.isTracing();
    }
}

