/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanExtractor;
import org.springframework.cloud.sleuth.instrument.web.ZipkinHttpSpanMapper;
import org.springframework.util.StringUtils;

public class ZipkinHttpSpanExtractor
implements HttpSpanExtractor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String HTTP_COMPONENT = "http";
    private static final ZipkinHttpSpanMapper SPAN_CARRIER_MAPPER = new ZipkinHttpSpanMapper();
    private final Pattern skipPattern;
    private final Random random;

    public ZipkinHttpSpanExtractor(Pattern skipPattern) {
        this.skipPattern = skipPattern;
        this.random = new Random();
    }

    @Override
    public Span joinTrace(SpanTextMap textMap) {
        boolean idToBeGenerated;
        Map<String, String> carrier = SPAN_CARRIER_MAPPER.convert(textMap);
        boolean debug = "1".equals(carrier.get("X-B3-Flags"));
        boolean bl = idToBeGenerated = debug && this.onlySpanIdIsPresent(carrier);
        if (!idToBeGenerated && this.traceIdIsMissing(carrier)) {
            return null;
        }
        try {
            return this.buildParentSpan(carrier, idToBeGenerated);
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while trying to extract span from carrier", (Throwable)e);
            return null;
        }
    }

    private boolean onlySpanIdIsPresent(Map<String, String> carrier) {
        return this.traceIdIsMissing(carrier) && this.spanIdIsPresent(carrier);
    }

    private boolean traceIdIsMissing(Map<String, String> carrier) {
        return carrier.get("X-B3-TraceId") == null;
    }

    private boolean spanIdIsPresent(Map<String, String> carrier) {
        return carrier.get("X-B3-SpanId") != null;
    }

    private String generateId() {
        return Span.idToHex(this.random.nextLong());
    }

    private long spanId(String spanId, String traceId) {
        if (spanId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Request is missing a span id but it has a trace id. We'll assume that this is a root span with span id equal to the lower 64-bits of the trace id");
            }
            return Span.hexToId(traceId);
        }
        return Span.hexToId(spanId);
    }

    private Span buildParentSpan(Map<String, String> carrier, boolean idToBeGenerated) {
        String parentId;
        String traceId = carrier.get("X-B3-TraceId");
        if (traceId == null) {
            traceId = this.generateId();
        }
        Span.SpanBuilder span = Span.builder().traceIdHigh(traceId.length() == 32 ? Span.hexToId(traceId, 0) : 0L).traceId(Span.hexToId(traceId)).spanId(this.spanId(carrier.get("X-B3-SpanId"), traceId));
        String parentName = carrier.get("X-Span-Name");
        if (StringUtils.hasText((String)parentName)) {
            span.name(parentName);
        } else {
            span.name("http:/parent" + carrier.get("X-Span-Uri"));
        }
        String processId = carrier.get("X-Process-Id");
        if (StringUtils.hasText((String)processId)) {
            span.processId(processId);
        }
        if ((parentId = carrier.get("X-B3-ParentSpanId")) != null) {
            span.parent(Span.hexToId(parentId));
        }
        span.remote(true);
        boolean skip = this.skipPattern.matcher(carrier.get("X-Span-Uri")).matches() || "0".equals(carrier.get("X-B3-Sampled"));
        span.shared(!skip && !idToBeGenerated);
        boolean debug = "1".equals(carrier.get("X-B3-Flags"));
        if (debug) {
            span.exportable(true);
        } else if (skip) {
            span.exportable(false);
        }
        for (Map.Entry<String, String> entry : carrier.entrySet()) {
            if (!entry.getKey().toLowerCase().startsWith("baggage-")) continue;
            span.baggage(this.unprefixedKey(entry.getKey()), entry.getValue());
        }
        return span.build();
    }

    private String unprefixedKey(String key) {
        return key.substring(key.indexOf("-") + 1).toLowerCase();
    }
}

