/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.TraceFilter;
import org.springframework.cloud.sleuth.instrument.web.TraceHttpAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.TraceSpringDataBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAspect;
import org.springframework.cloud.sleuth.instrument.web.TraceWebMvcConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@Role(value=2)
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TraceHttpAutoConfiguration.class})
public class TraceWebAutoConfiguration {
    @Bean
    public TraceWebAspect traceWebAspect(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, ErrorParser errorParser) {
        return new TraceWebAspect(tracer, spanNamer, traceKeys, errorParser);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.rest.webmvc.support.DelegatingHandlerMapping"})
    public TraceSpringDataBeanPostProcessor traceSpringDataBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceSpringDataBeanPostProcessor(beanFactory);
    }

    @Bean
    public FilterRegistrationBean traceWebFilter(TraceFilter traceFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)traceFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(-2147483643);
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceFilter traceFilter(BeanFactory beanFactory, SkipPatternProvider skipPatternProvider) {
        return new TraceFilter(beanFactory, skipPatternProvider.skipPattern());
    }

    @Configuration
    @ConditionalOnClass(value={WebMvcConfigurerAdapter.class})
    @Import(value={TraceWebMvcConfigurer.class})
    protected static class TraceWebMvcAutoConfiguration {
        protected TraceWebMvcAutoConfiguration() {
        }
    }
}

