/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging.websocket;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.cloud.sleuth.instrument.messaging.TraceChannelInterceptor;
import org.springframework.cloud.sleuth.instrument.messaging.TraceSpanMessagingAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;

@Component
@Configuration
@AutoConfigureAfter(value={TraceSpanMessagingAutoConfiguration.class})
@ConditionalOnClass(value={DelegatingWebSocketMessageBrokerConfiguration.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(value={"spring.sleuth.integration.websockets.enabled"}, matchIfMissing=true)
public class TraceWebSocketAutoConfiguration
extends AbstractWebSocketMessageBrokerConfigurer {
    @Autowired
    BeanFactory beanFactory;
    @Autowired
    Tracer tracer;
    @Autowired
    TraceKeys traceKeys;
    @Autowired
    MessagingSpanTextMapExtractor spanExtractor;
    @Autowired
    MessagingSpanTextMapInjector spanInjector;

    public void registerStompEndpoints(StompEndpointRegistry registry) {
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.configureBrokerChannel().setInterceptors(new ChannelInterceptor[]{new TraceChannelInterceptor(this.beanFactory)});
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.setInterceptors(new ChannelInterceptor[]{new TraceChannelInterceptor(this.beanFactory)});
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.setInterceptors(new ChannelInterceptor[]{new TraceChannelInterceptor(this.beanFactory)});
    }
}

