/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.instrument.messaging.AbstractTraceChannelInterceptor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingTextMap;
import org.springframework.cloud.sleuth.instrument.messaging.TraceMessageHeaders;
import org.springframework.cloud.sleuth.sampler.NeverSampler;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.ClassUtils;

public class TraceChannelInterceptor
extends AbstractTraceChannelInterceptor {
    private static final String ASYNC_COMPONENT = "async";
    private static final Log log = LogFactory.getLog(TraceChannelInterceptor.class);
    private final boolean hasDirectChannelClass = ClassUtils.isPresent((String)"org.springframework.integration.channel.DirectChannel", null);

    public TraceChannelInterceptor(BeanFactory beanFactory) {
        super(beanFactory);
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (this.isDirectChannel(channel)) {
            this.afterMessageHandled(message, channel, null, ex);
        }
        Message<?> retrievedMessage = this.getMessage(message);
        MessageBuilder messageBuilder = MessageBuilder.fromMessage(retrievedMessage);
        Span currentSpan = this.currentSpanOrFromHeaders(messageBuilder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Completed sending and current span is " + currentSpan));
        }
        this.getTracer().continueSpan(currentSpan);
        if (currentSpan != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with client received");
            }
            currentSpan.logEvent("cr");
        }
        this.addErrorTag(ex);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing messaging span " + currentSpan));
        }
        this.getTracer().close(currentSpan);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Messaging span " + currentSpan + " successfully closed"));
        }
    }

    private Span extractSpanOrPickCurrent(MessageBuilder<?> messageBuilder, MessageChannel channel) {
        if (this.isDirectChannel(channel)) {
            return this.currentSpanOrFromHeaders(messageBuilder);
        }
        Span spanFromMessage = this.spanFromHeaders(messageBuilder);
        Span currentSpan = this.getTracer().getCurrentSpan();
        if (currentSpan != null && currentSpan.equals(spanFromMessage)) {
            return currentSpan;
        }
        if (this.spanComesFromAsync(currentSpan)) {
            this.getTracer().detach(currentSpan);
            this.getTracer().continueSpan(spanFromMessage);
        }
        return spanFromMessage;
    }

    private boolean spanComesFromAsync(Span currentSpan) {
        return currentSpan != null && currentSpan.getSpanId() == currentSpan.getTraceId() && currentSpan.getName().equals(ASYNC_COMPONENT);
    }

    private Span currentSpanOrFromHeaders(MessageBuilder<?> messageBuilder) {
        return this.getTracer().isTracing() ? this.getTracer().getCurrentSpan() : this.spanFromHeaders(messageBuilder);
    }

    private Span spanFromHeaders(MessageBuilder<?> messageBuilder) {
        return this.buildSpan(new MessagingTextMap(messageBuilder));
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (this.emptyMessage(message)) {
            return message;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing message before sending it to the channel");
        }
        Message<?> retrievedMessage = this.getMessage(message);
        MessageBuilder messageBuilder = MessageBuilder.fromMessage(retrievedMessage);
        Span parentSpan = this.currentSpanOrFromHeaders(messageBuilder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parent span is " + parentSpan));
        }
        String name = this.getMessageChannelName(channel);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Name of the span will be [" + name + "]"));
        }
        Span span = this.startSpan(parentSpan, name, message);
        if (message.getHeaders().containsKey((Object)"messageSent")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with server received");
            }
            span.logEvent("sr");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with client send");
            }
            span.logEvent("cs");
            messageBuilder.setHeader("messageSent", (Object)true);
        }
        this.getSpanInjector().inject(span, new MessagingTextMap(messageBuilder));
        MessageHeaderAccessor headers = MessageHeaderAccessor.getMutableAccessor(message);
        Message<?> outputMessage = this.outputMessage(message, messageBuilder, headers);
        if (this.isDirectChannel(channel)) {
            this.beforeHandle(outputMessage, channel, null);
        }
        return outputMessage;
    }

    private boolean isDirectChannel(MessageChannel channel) {
        return this.hasDirectChannelClass && DirectChannel.class.isAssignableFrom(AopUtils.getTargetClass((Object)channel));
    }

    private Message<?> outputMessage(Message<?> message, MessageBuilder<?> messageBuilder, MessageHeaderAccessor headers) {
        if (this.emptyMessage(message)) {
            return message;
        }
        if (message instanceof ErrorMessage) {
            headers.copyHeaders(this.sleuthHeaders((Map<String, ?>)messageBuilder.build().getHeaders()));
            return new ErrorMessage((Throwable)message.getPayload(), headers.getMessageHeaders());
        }
        headers.copyHeaders((Map)messageBuilder.build().getHeaders());
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    private Map<String, ?> sleuthHeaders(Map<String, ?> headers) {
        HashMap headersToCopy = new HashMap();
        for (Map.Entry<String, ?> entry : headers.entrySet()) {
            if (!TraceMessageHeaders.ALL_HEADERS.contains(entry.getKey())) continue;
            headersToCopy.put(entry.getKey(), entry.getValue());
        }
        return headersToCopy;
    }

    private Message<?> getMessage(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof MessagingException) {
            MessagingException e = (MessagingException)payload;
            return e.getFailedMessage();
        }
        return message;
    }

    private Span startSpan(Span span, String name, Message<?> message) {
        if (span != null) {
            return this.getTracer().createSpan(name, span);
        }
        if ("0".equals(message.getHeaders().get((Object)"spanSampled"))) {
            return this.getTracer().createSpan(name, NeverSampler.INSTANCE);
        }
        return this.getTracer().createSpan(name);
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        if (this.emptyMessage(message)) {
            return message;
        }
        Message<?> retrievedMessage = this.getMessage(message);
        MessageBuilder messageBuilder = MessageBuilder.fromMessage(retrievedMessage);
        Span spanFromHeader = this.extractSpanOrPickCurrent(messageBuilder, channel);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Continuing span " + spanFromHeader + " before handling message"));
        }
        if (spanFromHeader != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with server received");
            }
            spanFromHeader.logEvent("sr");
        }
        this.getTracer().continueSpan(spanFromHeader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Span " + spanFromHeader + " successfully continued"));
        }
        return message;
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        Span spanFromHeader = this.getTracer().getCurrentSpan();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Continuing span " + spanFromHeader + " after message handled"));
        }
        if (spanFromHeader != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with server send");
            }
            spanFromHeader.logEvent("ss");
            this.addErrorTag(ex);
        }
        if (this.getTracer().isTracing() && !this.isDirectChannel(channel)) {
            this.getTracer().detach(spanFromHeader);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Detached " + spanFromHeader + " from current thread"));
            }
        }
    }

    private void addErrorTag(Exception ex) {
        if (ex != null) {
            this.getErrorParser().parseErrorTags(this.getTracer().getCurrentSpan(), ex);
        }
    }

    private boolean emptyMessage(Message<?> message) {
        return message == null;
    }
}

