/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceCallable;
import org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceRunnable;
import org.springframework.cloud.sleuth.instrument.async.TraceableExecutorService;

public class TraceableScheduledExecutorService
extends TraceableExecutorService
implements ScheduledExecutorService {
    public TraceableScheduledExecutorService(ScheduledExecutorService delegate, Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer) {
        super(delegate, tracer, traceKeys, spanNamer);
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        SpanContinuingTraceRunnable r = new SpanContinuingTraceRunnable(this.tracer, this.traceKeys, this.spanNamer, command);
        return this.getScheduledExecutorService().schedule(r, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        SpanContinuingTraceCallable<V> c = new SpanContinuingTraceCallable<V>(this.tracer, this.traceKeys, this.spanNamer, callable);
        return this.getScheduledExecutorService().schedule(c, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        SpanContinuingTraceRunnable r = new SpanContinuingTraceRunnable(this.tracer, this.traceKeys, this.spanNamer, command);
        return this.getScheduledExecutorService().scheduleAtFixedRate(r, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        SpanContinuingTraceRunnable r = new SpanContinuingTraceRunnable(this.tracer, this.traceKeys, this.spanNamer, command);
        return this.getScheduledExecutorService().scheduleWithFixedDelay(r, initialDelay, delay, unit);
    }
}

