/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.instrument.async.AsyncDefaultAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceAsyncCustomizer;
import org.springframework.cloud.sleuth.instrument.scheduling.TraceSchedulingAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;

@Configuration
@ConditionalOnBean(value={AsyncConfigurer.class})
@AutoConfigureBefore(value={AsyncDefaultAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.async.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={TraceSchedulingAutoConfiguration.class})
public class AsyncCustomAutoConfiguration
implements BeanPostProcessor {
    @Autowired
    private BeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AsyncConfigurer) {
            AsyncConfigurer configurer = (AsyncConfigurer)bean;
            return new LazyTraceAsyncCustomizer(this.beanFactory, configurer);
        }
        return bean;
    }
}

