/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.post;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.util.Pair;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.util.HTTPRequestUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

public class SendResponseFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(SendResponseFilter.class);
    private static DynamicBooleanProperty INCLUDE_DEBUG_HEADER = DynamicPropertyFactory.getInstance().getBooleanProperty("zuul.include-debug-header", false);
    private static DynamicIntProperty INITIAL_STREAM_BUFFER_SIZE = DynamicPropertyFactory.getInstance().getIntProperty("zuul.initial-stream-buffer-size", 8192);
    private static DynamicBooleanProperty SET_CONTENT_LENGTH = DynamicPropertyFactory.getInstance().getBooleanProperty("zuul.set-content-length", false);
    private boolean useServlet31 = true;
    private ThreadLocal<byte[]> buffers = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[INITIAL_STREAM_BUFFER_SIZE.get()];
        }
    };

    public SendResponseFilter() {
        try {
            HttpServletResponse.class.getMethod("setContentLengthLong", Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            this.useServlet31 = false;
        }
    }

    boolean isUseServlet31() {
        return this.useServlet31;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 1000;
    }

    public boolean shouldFilter() {
        RequestContext context = RequestContext.getCurrentContext();
        return context.getThrowable() == null && (!context.getZuulResponseHeaders().isEmpty() || context.getResponseDataStream() != null || context.getResponseBody() != null);
    }

    public Object run() {
        try {
            this.addResponseHeaders();
            this.writeResponse();
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse() throws Exception {
        RequestContext context = RequestContext.getCurrentContext();
        if (context.getResponseBody() == null && context.getResponseDataStream() == null) {
            return;
        }
        HttpServletResponse servletResponse = context.getResponse();
        if (servletResponse.getCharacterEncoding() == null) {
            servletResponse.setCharacterEncoding("UTF-8");
        }
        ServletOutputStream outStream = servletResponse.getOutputStream();
        InputStream is = null;
        try {
            if (RequestContext.getCurrentContext().getResponseBody() != null) {
                String body = RequestContext.getCurrentContext().getResponseBody();
                this.writeResponse(new ByteArrayInputStream(body.getBytes(servletResponse.getCharacterEncoding())), (OutputStream)outStream);
                return;
            }
            boolean isGzipRequested = false;
            String requestEncoding = context.getRequest().getHeader("accept-encoding");
            if (requestEncoding != null && HTTPRequestUtils.getInstance().isGzipped(requestEncoding)) {
                isGzipRequested = true;
            }
            InputStream inputStream = is = context.getResponseDataStream();
            if (is != null && context.sendZuulResponse()) {
                if (context.getResponseGZipped() && !isGzipRequested) {
                    Long len = context.getOriginContentLength();
                    if (len == null || len > 0L) {
                        try {
                            inputStream = new GZIPInputStream(is);
                        }
                        catch (ZipException ex) {
                            log.debug((Object)("gzip expected but not received assuming unencoded response " + RequestContext.getCurrentContext().getRequest().getRequestURL().toString()));
                            inputStream = is;
                        }
                    }
                } else if (context.getResponseGZipped() && isGzipRequested) {
                    servletResponse.setHeader("Content-Encoding", "gzip");
                }
                this.writeResponse(inputStream, (OutputStream)outStream);
            }
        }
        finally {
            try {
                Object zuulResponse = RequestContext.getCurrentContext().get((Object)"zuulResponse");
                if (zuulResponse instanceof Closeable) {
                    ((Closeable)zuulResponse).close();
                }
                outStream.flush();
            }
            catch (IOException ex) {
                log.warn((Object)("Error while sending response to client: " + ex.getMessage()));
            }
        }
    }

    private void writeResponse(InputStream zin, OutputStream out) throws Exception {
        byte[] bytes = this.buffers.get();
        int bytesRead = -1;
        while ((bytesRead = zin.read(bytes)) != -1) {
            out.write(bytes, 0, bytesRead);
        }
    }

    private void addResponseHeaders() {
        Long contentLength;
        List zuulResponseHeaders;
        List rd;
        RequestContext context = RequestContext.getCurrentContext();
        HttpServletResponse servletResponse = context.getResponse();
        if (INCLUDE_DEBUG_HEADER.get() && (rd = (List)context.get((Object)"routingDebug")) != null) {
            StringBuilder debugHeader = new StringBuilder();
            for (String it : rd) {
                debugHeader.append("[[[" + it + "]]]");
            }
            servletResponse.addHeader("X-Zuul-Debug-Header", debugHeader.toString());
        }
        if ((zuulResponseHeaders = context.getZuulResponseHeaders()) != null) {
            for (Pair it : zuulResponseHeaders) {
                servletResponse.addHeader((String)it.first(), (String)it.second());
            }
        }
        if (SET_CONTENT_LENGTH.get() && (contentLength = context.getOriginContentLength()) != null && !context.getResponseGZipped()) {
            if (this.useServlet31) {
                servletResponse.setContentLengthLong(contentLength.longValue());
            } else if (this.isLongSafe(contentLength)) {
                servletResponse.setContentLength(contentLength.intValue());
            }
        }
    }

    private boolean isLongSafe(long value) {
        return value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE;
    }
}

