/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.IClient;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.context.named.NamedContextFactory;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.cloud.netflix.ribbon.RibbonClientSpecification;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringClientFactory
extends NamedContextFactory<RibbonClientSpecification> {
    public SpringClientFactory() {
        super(RibbonClientConfiguration.class, "ribbon", "ribbon.client.name");
    }

    public <C extends IClient<?, ?>> C getClient(String name, Class<C> clientClass) {
        return (C)((IClient)this.getInstance(name, clientClass));
    }

    public ILoadBalancer getLoadBalancer(String name) {
        return this.getInstance(name, ILoadBalancer.class);
    }

    public IClientConfig getClientConfig(String name) {
        return this.getInstance(name, IClientConfig.class);
    }

    public RibbonLoadBalancerContext getLoadBalancerContext(String serviceId) {
        return this.getInstance(serviceId, RibbonLoadBalancerContext.class);
    }

    private <C> C instantiateWithConfig(AnnotationConfigApplicationContext context, Class<C> clazz, IClientConfig config) {
        Object result = null;
        if (IClientConfigAware.class.isAssignableFrom(clazz)) {
            IClientConfigAware value;
            IClientConfigAware obj = (IClientConfigAware)BeanUtils.instantiate(clazz);
            obj.initWithNiwsConfig(config);
            result = value = obj;
        } else {
            try {
                result = clazz.getConstructor(IClientConfig.class) != null ? clazz.getConstructor(IClientConfig.class).newInstance(config) : BeanUtils.instantiate(clazz);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        context.getAutowireCapableBeanFactory().autowireBean(result);
        return (C)result;
    }

    public <C> C getInstance(String name, Class<C> type) {
        Object instance = super.getInstance(name, type);
        if (instance != null) {
            return (C)instance;
        }
        IClientConfig config = this.getInstance(name, IClientConfig.class);
        return this.instantiateWithConfig(this.getContext(name), type, config);
    }
}

