/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.util.collections.ListUtil;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MatchableInvocation;

public class InvocationsFinder {
    private InvocationsFinder() {
    }

    public static List<Invocation> findInvocations(List<Invocation> invocations, MatchableInvocation wanted) {
        return ListUtil.filter(invocations, new RemoveNotMatching(wanted));
    }

    public static List<Invocation> findAllMatchingUnverifiedChunks(List<Invocation> invocations, MatchableInvocation wanted, InOrderContext orderingContext) {
        List<Invocation> unverified = InvocationsFinder.removeVerifiedInOrder(invocations, orderingContext);
        return ListUtil.filter(unverified, new RemoveNotMatching(wanted));
    }

    public static List<Invocation> findMatchingChunk(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount, InOrderContext context) {
        List<Invocation> unverified = InvocationsFinder.removeVerifiedInOrder(invocations, context);
        List<Invocation> firstChunk = InvocationsFinder.getFirstMatchingChunk(wanted, unverified);
        if (wantedCount != firstChunk.size()) {
            return InvocationsFinder.findAllMatchingUnverifiedChunks(invocations, wanted, context);
        }
        return firstChunk;
    }

    private static List<Invocation> getFirstMatchingChunk(MatchableInvocation wanted, List<Invocation> unverified) {
        LinkedList<Invocation> firstChunk = new LinkedList<Invocation>();
        for (Invocation invocation : unverified) {
            if (wanted.matches(invocation)) {
                firstChunk.add(invocation);
                continue;
            }
            if (firstChunk.isEmpty()) continue;
            break;
        }
        return firstChunk;
    }

    public static Invocation findFirstMatchingUnverifiedInvocation(List<Invocation> invocations, MatchableInvocation wanted, InOrderContext context) {
        for (Invocation invocation : InvocationsFinder.removeVerifiedInOrder(invocations, context)) {
            if (!wanted.matches(invocation)) continue;
            return invocation;
        }
        return null;
    }

    public static Invocation findSimilarInvocation(List<Invocation> invocations, MatchableInvocation wanted) {
        Invocation firstSimilar = null;
        for (Invocation invocation : invocations) {
            if (!wanted.hasSimilarMethod(invocation)) continue;
            if (firstSimilar == null) {
                firstSimilar = invocation;
            }
            if (!wanted.hasSameMethod(invocation)) continue;
            return invocation;
        }
        return firstSimilar;
    }

    public static Invocation findFirstUnverified(List<Invocation> invocations) {
        return InvocationsFinder.findFirstUnverified(invocations, null);
    }

    static Invocation findFirstUnverified(List<Invocation> invocations, Object mock) {
        for (Invocation i : invocations) {
            boolean mockIsValid;
            boolean bl = mockIsValid = mock == null || mock == i.getMock();
            if (i.isVerified() || !mockIsValid) continue;
            return i;
        }
        return null;
    }

    public static Location getLastLocation(List<Invocation> invocations) {
        if (invocations.isEmpty()) {
            return null;
        }
        Invocation last = invocations.get(invocations.size() - 1);
        return last.getLocation();
    }

    public static Invocation findPreviousVerifiedInOrder(List<Invocation> invocations, InOrderContext context) {
        LinkedList<Invocation> verifiedOnly = ListUtil.filter(invocations, new RemoveUnverifiedInOrder(context));
        if (verifiedOnly.isEmpty()) {
            return null;
        }
        return verifiedOnly.getLast();
    }

    private static List<Invocation> removeVerifiedInOrder(List<Invocation> invocations, InOrderContext orderingContext) {
        LinkedList<Invocation> unverified = new LinkedList<Invocation>();
        for (Invocation i : invocations) {
            if (orderingContext.isVerified(i)) {
                unverified.clear();
                continue;
            }
            unverified.add(i);
        }
        return unverified;
    }

    public static Invocation findFirstUnverifiedInOrder(InOrderContext context, List<Invocation> orderedInvocations) {
        Invocation candidate = null;
        for (Invocation i : orderedInvocations) {
            if (!context.isVerified(i)) {
                candidate = candidate != null ? candidate : i;
                continue;
            }
            candidate = null;
        }
        return candidate;
    }

    private static class RemoveUnverifiedInOrder
    implements ListUtil.Filter<Invocation> {
        private final InOrderContext orderingContext;

        public RemoveUnverifiedInOrder(InOrderContext orderingContext) {
            this.orderingContext = orderingContext;
        }

        @Override
        public boolean isOut(Invocation invocation) {
            return !this.orderingContext.isVerified(invocation);
        }
    }

    private static class RemoveNotMatching
    implements ListUtil.Filter<Invocation> {
        private final MatchableInvocation wanted;

        private RemoveNotMatching(MatchableInvocation wanted) {
            this.wanted = wanted;
        }

        @Override
        public boolean isOut(Invocation invocation) {
            return !this.wanted.matches(invocation);
        }
    }
}

