/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.util;

import java.io.IOException;
import java.io.InputStream;

public class Tools {
    public static String getParent(String path) {
        int endIndex;
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return (endIndex = Math.max(path.lastIndexOf("/"), path.lastIndexOf("\\"))) > -1 ? path.substring(0, endIndex) : null;
    }

    public static String join(String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            boolean rightHas;
            String left = sb.toString();
            boolean leftHas = left.endsWith("/") || left.endsWith("\\");
            boolean bl = rightHas = path.startsWith("/") || path.startsWith("\\");
            if (leftHas && rightHas) {
                sb.append(path.substring(1));
                continue;
            }
            if (!(left.isEmpty() || leftHas || rightHas)) {
                sb.append("/").append(path);
                continue;
            }
            sb.append(path);
        }
        return sb.toString();
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static long getSize(InputStream in) throws IOException {
        long size = 0L;
        while (in.read() != -1) {
            ++size;
        }
        return size;
    }

    @SafeVarargs
    public static <T> T getNotNull(T ... args) {
        for (T t : args) {
            if (t == null) continue;
            return t;
        }
        throw new NullPointerException();
    }
}

