/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.upload;

import java.util.ArrayList;
import java.util.List;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.ListPartsAspectChain;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;

public class ListPartsActuator {
    private final FileStorageService fileStorageService;
    private final ListPartsPretreatment pre;

    public ListPartsActuator(ListPartsPretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
    }

    public FilePartInfoList execute() {
        return this.execute((FileStorage)this.fileStorageService.getFileStorageVerify(this.pre.getFileInfo().getPlatform()), (List<FileStorageAspect>)this.fileStorageService.getAspectList());
    }

    public FilePartInfoList execute(FileStorage fileStorage, List<FileStorageAspect> aspectList) {
        Check.listParts(this.pre.getFileInfo());
        return new ListPartsAspectChain(aspectList, (_pre, _fileStorage) -> {
            FilePartInfoList tempList;
            MultipartUploadSupportInfo supportInfo = this.fileStorageService.isSupportMultipartUpload(_fileStorage);
            Integer supportMaxParts = supportInfo.getListPartsSupportMaxParts();
            if (supportMaxParts == null || _pre.getMaxParts() <= supportMaxParts) {
                return _fileStorage.listParts(_pre);
            }
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(_pre.getFileInfo());
            list.setList(new ArrayList<FilePartInfo>());
            list.setMaxParts(_pre.getMaxParts());
            list.setPartNumberMarker(_pre.getPartNumberMarker());
            Integer residuePartNum = _pre.getMaxParts();
            Integer partNumberMarker = _pre.getPartNumberMarker();
            do {
                ListPartsPretreatment tempPre = new ListPartsPretreatment(_pre);
                tempPre.setMaxParts(residuePartNum <= supportMaxParts ? residuePartNum : supportMaxParts);
                tempPre.setPartNumberMarker(partNumberMarker);
                tempList = _fileStorage.listParts(tempPre);
                list.getList().addAll(tempList.getList());
                residuePartNum = residuePartNum - supportMaxParts;
                partNumberMarker = tempList.getNextPartNumberMarker();
            } while (residuePartNum > 0 && tempList.getIsTruncated().booleanValue());
            list.setNextPartNumberMarker(tempList.getNextPartNumberMarker());
            list.setIsTruncated(tempList.getIsTruncated());
            return list;
        }).next(this.pre, fileStorage);
    }
}

