/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.upload;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.InitiateMultipartUploadAspectChain;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;

public class InitiateMultipartUploadActuator {
    private final FileStorageService fileStorageService;
    private final InitiateMultipartUploadPretreatment pre;

    public InitiateMultipartUploadActuator(InitiateMultipartUploadPretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
    }

    public FileInfo execute() {
        Object fileStorage = this.fileStorageService.getFileStorageVerify(this.pre.getPlatform());
        FileInfo fileInfo = new FileInfo();
        fileInfo.setCreateTime(new Date());
        fileInfo.setSize(this.pre.getSize());
        fileInfo.setOriginalFilename(this.pre.getOriginalFilename());
        fileInfo.setExt(FileNameUtil.getSuffix((String)this.pre.getOriginalFilename()));
        fileInfo.setObjectId(this.pre.getObjectId());
        fileInfo.setObjectType(this.pre.getObjectType());
        fileInfo.setPath(this.pre.getPath());
        fileInfo.setPlatform(this.pre.getPlatform());
        fileInfo.setMetadata(this.pre.getMetadata());
        fileInfo.setUserMetadata(this.pre.getUserMetadata());
        fileInfo.setAttr(this.pre.getAttr());
        fileInfo.setFileAcl(this.pre.getFileAcl());
        fileInfo.setUploadStatus(1);
        if (StrUtil.isNotBlank((CharSequence)this.pre.getSaveFilename())) {
            fileInfo.setFilename(this.pre.getSaveFilename());
        } else {
            fileInfo.setFilename(IdUtil.objectId() + (StrUtil.isEmpty((CharSequence)fileInfo.getExt()) ? "" : "." + fileInfo.getExt()));
        }
        fileInfo.setContentType(this.pre.getContentType());
        CopyOnWriteArrayList<FileStorageAspect> aspectList = this.fileStorageService.getAspectList();
        FileRecorder fileRecorder = this.fileStorageService.getFileRecorder();
        return new InitiateMultipartUploadAspectChain(aspectList, (_fileInfo, _pre, _fileStorage, _fileRecorder) -> {
            _fileStorage.initiateMultipartUpload(_fileInfo, _pre);
            try {
                if (!_fileRecorder.save(_fileInfo)) {
                    throw new RuntimeException("\u6587\u4ef6\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                }
            }
            catch (Exception e) {
                throw ExceptionFactory.initiateMultipartUploadRecorderSave(_fileInfo, _fileStorage.getPlatform(), e);
            }
            return _fileInfo;
        }).next(fileInfo, this.pre, (FileStorage)fileStorage, fileRecorder);
    }
}

