/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.upload;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dromara.x.file.storage.core.Downloader;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.CompleteMultipartUploadAspectChain;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.recorder.FileRecorder;
import org.dromara.x.file.storage.core.tika.ContentTypeDetect;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;

public class CompleteMultipartUploadActuator {
    private final FileStorageService fileStorageService;
    private final CompleteMultipartUploadPretreatment pre;

    public CompleteMultipartUploadActuator(CompleteMultipartUploadPretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
    }

    public FileInfo execute() {
        FileInfo fileInfo = this.pre.getFileInfo();
        Check.completeMultipartUpload(fileInfo);
        Object fileStorage = this.fileStorageService.getFileStorageVerify(fileInfo.getPlatform());
        fileInfo.setUploadStatus(2);
        CopyOnWriteArrayList<FileStorageAspect> aspectList = this.fileStorageService.getAspectList();
        FileRecorder fileRecorder = this.fileStorageService.getFileRecorder();
        ContentTypeDetect contentTypeDetect = this.fileStorageService.getContentTypeDetect();
        return new CompleteMultipartUploadAspectChain(aspectList, (_pre, _fileStorage, _fileRecorder, _contentTypeDetect) -> {
            FileInfo _fileInfo = _pre.getFileInfo();
            MultipartUploadSupportInfo supportInfo = this.fileStorageService.isSupportMultipartUpload(_fileStorage);
            if (_pre.getPartInfoList() == null && supportInfo.getIsSupportListParts().booleanValue()) {
                FilePartInfoList partInfoList = this.fileStorageService.listParts(_fileInfo).listParts(_fileStorage, aspectList);
                _pre.setPartInfoList(partInfoList.getList());
            }
            _fileStorage.completeMultipartUpload(_pre);
            _fileRecorder.update(_fileInfo);
            _fileRecorder.deleteFilePartByUploadId(_fileInfo.getUploadId());
            if (StrUtil.isNotBlank((CharSequence)_fileInfo.getContentType())) {
                try {
                    new Downloader(_fileInfo, aspectList, _fileStorage, 1).inputStream(in -> {
                        try {
                            _fileInfo.setContentType(_contentTypeDetect.detect((InputStream)in, _fileInfo.getOriginalFilename()));
                            IoUtil.close((Closeable)in);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    _fileRecorder.update(_fileInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return _fileInfo;
        }).next(this.pre, (FileStorage)fileStorage, fileRecorder, contentTypeDetect);
    }
}

