/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.ftp.FtpException;
import cn.hutool.extra.ssh.JschUtil;
import cn.hutool.extra.ssh.Sftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpFileStorageClientFactory
implements FileStorageClientFactory<Sftp> {
    private static final Logger log = LoggerFactory.getLogger(SftpFileStorageClientFactory.class);
    private String platform;
    private String host;
    private Integer port;
    private String user;
    private String password;
    private String privateKeyPath;
    private Charset charset;
    private Integer connectionTimeout;
    private GenericObjectPoolConfig<Sftp> poolConfig;
    private volatile GenericObjectPool<Sftp> pool;

    public SftpFileStorageClientFactory(FileStorageProperties.SftpConfig config) {
        this.platform = config.getPlatform();
        this.host = config.getHost();
        this.port = config.getPort();
        this.user = config.getUser();
        this.password = config.getPassword();
        this.privateKeyPath = config.getPrivateKeyPath();
        this.charset = config.getCharset();
        this.connectionTimeout = config.getConnectionTimeout();
        this.poolConfig = config.getPool().toGenericObjectPoolConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sftp getClient() {
        try {
            if (this.pool == null) {
                SftpFileStorageClientFactory sftpFileStorageClientFactory = this;
                synchronized (sftpFileStorageClientFactory) {
                    if (this.pool == null) {
                        this.pool = new GenericObjectPool((PooledObjectFactory)new SftpPooledObjectFactory(this), this.poolConfig);
                    }
                }
            }
            return (Sftp)this.pool.borrowObject();
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u83b7\u53d6 SFTP Client \u5931\u8d25\uff01", e);
        }
    }

    @Override
    public void returnClient(Sftp sftp) {
        try {
            this.pool.returnObject((Object)sftp);
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u5f52\u8fd8 SFTP Client \u5931\u8d25\uff01", e);
        }
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.close();
            this.pool = null;
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public GenericObjectPoolConfig<Sftp> getPoolConfig() {
        return this.poolConfig;
    }

    public GenericObjectPool<Sftp> getPool() {
        return this.pool;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setPoolConfig(GenericObjectPoolConfig<Sftp> poolConfig) {
        this.poolConfig = poolConfig;
    }

    public void setPool(GenericObjectPool<Sftp> pool) {
        this.pool = pool;
    }

    public SftpFileStorageClientFactory() {
    }

    public static class SftpPooledObjectFactory
    extends BasePooledObjectFactory<Sftp> {
        private static final Logger log = LoggerFactory.getLogger(SftpPooledObjectFactory.class);
        private SftpFileStorageClientFactory factory;

        public Sftp create() {
            Session session = null;
            try {
                if (StrUtil.isNotBlank((CharSequence)this.factory.getPrivateKeyPath())) {
                    byte[] passphrase = StrUtil.isBlank((CharSequence)this.factory.getPassword()) ? null : this.factory.getPassword().getBytes(StandardCharsets.UTF_8);
                    JSch jsch = new JSch();
                    byte[] privateKey = IoUtil.readBytes((InputStream)URLUtil.url((String)this.factory.getPrivateKeyPath()).openStream());
                    jsch.addIdentity(this.factory.getPrivateKeyPath(), privateKey, null, passphrase);
                    session = JschUtil.createSession((JSch)jsch, (String)this.factory.getHost(), (int)this.factory.getPort(), (String)this.factory.getUser());
                    session.connect(this.factory.getConnectionTimeout().intValue());
                } else {
                    session = JschUtil.openSession((String)this.factory.getHost(), (int)this.factory.getPort(), (String)this.factory.getUser(), (String)this.factory.getPassword(), (int)this.factory.getConnectionTimeout());
                }
                return new Sftp(session, this.factory.getCharset(), (long)this.factory.getConnectionTimeout().intValue());
            }
            catch (Exception e) {
                JschUtil.close(session);
                throw new FileStorageRuntimeException("SFTP \u8fde\u63a5\u5931\u8d25\uff01platform\uff1a" + this.factory.getPlatform(), e);
            }
        }

        public PooledObject<Sftp> wrap(Sftp sftp) {
            return new DefaultPooledObject((Object)sftp);
        }

        public boolean validateObject(PooledObject<Sftp> p) {
            try {
                ((Sftp)p.getObject()).cd(".");
                return true;
            }
            catch (FtpException e) {
                log.warn("\u9a8c\u8bc1 Sftp \u5bf9\u8c61\u5931\u8d25", (Throwable)e);
                return false;
            }
        }

        public void destroyObject(PooledObject<Sftp> p) {
            ((Sftp)p.getObject()).close();
        }

        public SftpPooledObjectFactory(SftpFileStorageClientFactory factory) {
            this.factory = factory;
        }
    }
}

