/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Multimap;
import io.minio.AbortMultipartUploadResponse;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.CreateMultipartUploadResponse;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListPartsResponse;
import io.minio.MinioAsyncClient;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadPartResponse;
import io.minio.errors.ErrorResponseException;
import io.minio.messages.ListPartsResult;
import io.minio.messages.Part;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

public class MinioFileStorage
implements FileStorage {
    private String platform;
    private String bucketName;
    private String domain;
    private String basePath;
    private int multipartThreshold;
    private int multipartPartSize;
    private FileStorageClientFactory<MinioClient> clientFactory;

    public MinioFileStorage(FileStorageProperties.MinioConfig config, FileStorageClientFactory<MinioClient> clientFactory) {
        this.platform = config.getPlatform();
        this.bucketName = config.getBucketName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.multipartThreshold = config.getMultipartThreshold();
        this.multipartPartSize = config.getMultipartPartSize();
        this.clientFactory = clientFactory;
    }

    public MinioClient getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block13: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
            MinioClient client = this.getClient();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                byte[] thumbnailBytes;
                Long objectSize = fileInfo.getSize();
                long partSize = -1L;
                if (fileInfo.getSize() == null || fileInfo.getSize() >= (long)this.multipartThreshold) {
                    objectSize = -1L;
                    partSize = this.multipartPartSize;
                }
                client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(newFileKey)).stream((InputStream)in, objectSize.longValue(), partSize).contentType(fileInfo.getContentType()).headers(fileInfo.getMetadata())).userMetadata(fileInfo.getUserMetadata())).build());
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(newThFileKey)).stream((InputStream)new ByteArrayInputStream(thumbnailBytes), (long)thumbnailBytes.length, -1L).contentType(fileInfo.getThContentType()).headers(fileInfo.getThMetadata())).userMetadata(fileInfo.getThUserMetadata())).build());
                }
                bl = true;
                if (in == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(newFileKey)).build());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return bl;
    }

    public MinioAsyncClient getMinioAsyncClient(MinioClient client) {
        return (MinioAsyncClient)ReflectUtil.getFieldValue((Object)client, (String)"asyncClient");
    }

    public CreateMultipartUploadResponse initiateMultipartUpload(MinioClient client, PutObjectArgs args) throws ExecutionException, InterruptedException {
        MinioAsyncClient asyncClient = this.getMinioAsyncClient(client);
        Multimap headers = (Multimap)ReflectUtil.invoke((Object)asyncClient, (String)"newMultimap", (Object[])new Object[]{args.extraHeaders()});
        headers.putAll(args.genHeaders());
        Method method = ReflectUtil.getMethodByName(asyncClient.getClass(), (String)"createMultipartUploadAsync");
        CompletableFuture cf = (CompletableFuture)ReflectUtil.invoke((Object)asyncClient, (Method)method, (Object[])new Object[]{args.bucket(), args.region(), args.object(), headers, args.extraQueryParams()});
        return (CreateMultipartUploadResponse)cf.get();
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll();
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
        MinioClient client = this.getClient();
        try {
            PutObjectArgs.Builder builder = (PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(newFileKey);
            if (fileInfo.getContentType() != null) {
                builder.contentType(fileInfo.getContentType());
            }
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)builder.headers(fileInfo.getMetadata())).userMetadata(fileInfo.getUserMetadata())).stream((InputStream)new ByteArrayInputStream(new byte[0]), 0L, 0L).build();
            String uploadId = this.initiateMultipartUpload(client, args).result().uploadId();
            fileInfo.setUploadId(uploadId);
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    public UploadPartResponse uploadPart(MinioClient client, String uploadId, int partNumber, PutObjectArgs args) throws ExecutionException, InterruptedException {
        MinioAsyncClient asyncClient = this.getMinioAsyncClient(client);
        Method newPartReaderMethod = ReflectUtil.getMethodByName(asyncClient.getClass(), (String)"newPartReader");
        Object partReader = ReflectUtil.invoke((Object)asyncClient, (Method)newPartReaderMethod, (Object[])new Object[]{args.stream(), args.objectSize(), args.partSize(), 1});
        Object partSource = ReflectUtil.invoke((Object)partReader, (String)"getPart", (Object[])new Object[0]);
        Method uploadPartsMethod = ReflectUtil.getMethodByName(asyncClient.getClass(), (String)"uploadPartAsync");
        CompletableFuture result = (CompletableFuture)ReflectUtil.invoke((Object)asyncClient, (Method)uploadPartsMethod, (Object[])new Object[]{args.bucket(), args.region(), args.object(), partSource, partNumber, uploadId, null, null});
        return (UploadPartResponse)result.get();
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block9: {
            FileInfo fileInfo = pre.getFileInfo();
            String newFileKey = this.getFileKey(fileInfo);
            MinioClient client = this.getClient();
            FileWrapper partFileWrapper = pre.getPartFileWrapper();
            Long partSize = partFileWrapper.getSize();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                if (partSize == null) {
                    partSize = partFileWrapper.getInputStreamMaskResetReturn(Tools::getSize);
                }
                PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(newFileKey)).stream((InputStream)in, partSize.longValue(), -1L).build();
                UploadPartResponse part = this.uploadPart(client, fileInfo.getUploadId(), pre.getPartNumber(), args);
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(part.etag());
                filePartInfo2.setPartNumber(part.partNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    public ObjectWriteResponse completeMultipartUpload(MinioClient client, String uploadId, Part[] parts, PutObjectArgs args) throws ExecutionException, InterruptedException {
        MinioAsyncClient asyncClient = this.getMinioAsyncClient(client);
        Method method = ReflectUtil.getMethodByName(asyncClient.getClass(), (String)"completeMultipartUploadAsync");
        CompletableFuture cf = (CompletableFuture)ReflectUtil.invoke((Object)asyncClient, (Method)method, (Object[])new Object[]{args.bucket(), args.region(), args.object(), uploadId, parts, null, null});
        return (ObjectWriteResponse)cf.get();
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        MinioClient client = this.getClient();
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(newFileKey)).stream((InputStream)new ByteArrayInputStream(new byte[0]), 0L, 0L).build();
            Part[] parts = (Part[])pre.getPartInfoList().stream().map(part -> new Part(part.getPartNumber().intValue(), part.getETag())).toArray(Part[]::new);
            ProgressListener.quickStart(pre.getProgressListener(), fileInfo.getSize());
            this.completeMultipartUpload(client, fileInfo.getUploadId(), parts, args);
            ProgressListener.quickFinish(pre.getProgressListener(), fileInfo.getSize());
        }
        catch (Exception e) {
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    public AbortMultipartUploadResponse abortMultipartUpload(MinioClient client, String uploadId, PutObjectArgs args) throws ExecutionException, InterruptedException {
        MinioAsyncClient asyncClient = this.getMinioAsyncClient(client);
        Method method = ReflectUtil.getMethodByName(asyncClient.getClass(), (String)"abortMultipartUploadAsync");
        CompletableFuture cf = (CompletableFuture)ReflectUtil.invoke((Object)asyncClient, (Method)method, (Object[])new Object[]{args.bucket(), args.region(), args.object(), uploadId, null, null});
        return (AbortMultipartUploadResponse)cf.get();
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        MinioClient client = this.getClient();
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(newFileKey)).stream((InputStream)new ByteArrayInputStream(new byte[0]), 0L, 0L).build();
            this.abortMultipartUpload(client, fileInfo.getUploadId(), args);
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    public ListPartsResult listParts(MinioClient client, String uploadId, Integer maxParts, Integer partNumberMarker, PutObjectArgs args) throws ExecutionException, InterruptedException {
        MinioAsyncClient asyncClient = this.getMinioAsyncClient(client);
        Method method = ReflectUtil.getMethodByName(asyncClient.getClass(), (String)"listPartsAsync");
        Multimap headers = (Multimap)ReflectUtil.invoke((Object)asyncClient, (String)"newMultimap", (Object[])new Object[]{args.extraHeaders()});
        headers.putAll(args.genHeaders());
        CompletableFuture result = (CompletableFuture)ReflectUtil.invoke((Object)asyncClient, (Method)method, (Object[])new Object[]{args.bucket(), args.region(), args.object(), maxParts, partNumberMarker, uploadId, headers, args.extraQueryParams()});
        return ((ListPartsResponse)result.get()).result();
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        MinioClient client = this.getClient();
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(newFileKey)).stream((InputStream)new ByteArrayInputStream(new byte[0]), 0L, 0L).build();
            ListPartsResult result = this.listParts(client, fileInfo.getUploadId(), pre.getMaxParts(), pre.getPartNumberMarker(), args);
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            list.setList(result.partList().stream().map(p -> {
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setETag(p.etag());
                filePartInfo.setPartNumber(p.partNumber());
                filePartInfo.setPartSize(p.partSize());
                filePartInfo.setLastModified((Date)DateUtil.date((TemporalAccessor)p.lastModified()));
                return filePartInfo;
            }).collect(Collectors.toList()));
            list.setMaxParts(result.maxParts());
            list.setIsTruncated(result.isTruncated());
            list.setPartNumberMarker(result.partNumberMarker());
            list.setNextPartNumberMarker(result.nextPartNumberMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    @Override
    public String generatePresignedUrl(FileInfo fileInfo, Date expiration) {
        int expiry = (int)((expiration.getTime() - System.currentTimeMillis()) / 1000L);
        try {
            GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.bucketName)).object(this.getFileKey(fileInfo))).method(io.minio.http.Method.GET).expiry(expiry).build();
            return this.getClient().getPresignedObjectUrl(args);
        }
        catch (Exception e) {
            throw ExceptionFactory.generatePresignedUrl(fileInfo, this.platform, e);
        }
    }

    @Override
    public String generateThPresignedUrl(FileInfo fileInfo, Date expiration) {
        String key = this.getThFileKey(fileInfo);
        if (key == null) {
            return null;
        }
        int expiry = (int)((expiration.getTime() - System.currentTimeMillis()) / 1000L);
        try {
            GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.bucketName)).object(key)).method(io.minio.http.Method.GET).expiry(expiry).build();
            return this.getClient().getPresignedObjectUrl(args);
        }
        catch (Exception e) {
            throw ExceptionFactory.generateThPresignedUrl(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        MinioClient client = this.getClient();
        try {
            if (fileInfo.getThFilename() != null) {
                client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(this.getThFileKey(fileInfo))).build());
            }
            client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(this.getFileKey(fileInfo))).build());
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        MinioClient client = this.getClient();
        try {
            StatObjectResponse stat = client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(this.getFileKey(fileInfo))).build());
            return stat != null && stat.lastModified() != null;
        }
        catch (ErrorResponseException e) {
            String code = e.errorResponse().code();
            if ("NoSuchKey".equals(code)) {
                return false;
            }
            throw ExceptionFactory.exists(fileInfo, this.platform, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        MinioClient client = this.getClient();
        try (GetObjectResponse in = client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.bucketName)).object(this.getFileKey(fileInfo))).build());){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        MinioClient client = this.getClient();
        try (GetObjectResponse in = client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.bucketName)).object(this.getThFileKey(fileInfo))).build());){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        StatObjectResponse srcFile;
        Check.sameCopyNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        MinioClient client = this.getClient();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            srcFile = client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(srcFileKey)).build());
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                client.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(this.bucketName)).object(destThFileKey)).source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(this.bucketName)).object(this.getThFileKey(srcFileInfo))).build()).build());
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        long fileSize = srcFile.size();
        boolean useMultipartCopy = fileSize >= 0x40000000L;
        try {
            ProgressListener.quickStart(pre.getProgressListener(), fileSize);
            if (useMultipartCopy) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", destFileInfo.getContentType());
                headers.putAll(destFileInfo.getMetadata());
                client.composeObject((ComposeObjectArgs)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)ComposeObjectArgs.builder().bucket(this.bucketName)).object(destFileKey)).headers(headers)).userMetadata(destFileInfo.getUserMetadata())).sources(Collections.singletonList((ComposeSource)((ComposeSource.Builder)((ComposeSource.Builder)((ComposeSource.Builder)((ComposeSource.Builder)ComposeSource.builder().bucket(this.bucketName)).object(srcFileKey)).offset(Long.valueOf(0L))).length(Long.valueOf(fileSize))).build())).build());
            } else {
                client.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(this.bucketName)).object(destFileKey)).source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(this.bucketName)).object(srcFileKey)).build()).build());
            }
            ProgressListener.quickFinish(pre.getProgressListener(), fileSize);
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(destThFileKey)).build());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(destFileKey)).build());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public int getMultipartThreshold() {
        return this.multipartThreshold;
    }

    public int getMultipartPartSize() {
        return this.multipartPartSize;
    }

    public FileStorageClientFactory<MinioClient> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setMultipartThreshold(int multipartThreshold) {
        this.multipartThreshold = multipartThreshold;
    }

    public void setMultipartPartSize(int multipartPartSize) {
        this.multipartPartSize = multipartPartSize;
    }

    public void setClientFactory(FileStorageClientFactory<MinioClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public MinioFileStorage() {
    }
}

