/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.StrUtil;
import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class GoogleCloudStorageFileStorage
implements FileStorage {
    private String projectId;
    private String bucketName;
    private String credentialsPath;
    private String basePath;
    private String platform;
    private String domain;
    private String defaultAcl;
    private FileStorageClientFactory<Storage> clientFactory;

    public GoogleCloudStorageFileStorage(FileStorageProperties.GoogleCloudStorageConfig config, FileStorageClientFactory<Storage> clientFactory) {
        this.platform = config.getPlatform();
        this.bucketName = config.getBucketName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.defaultAcl = config.getDefaultAcl();
        this.clientFactory = clientFactory;
    }

    public Storage getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block12: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            ArrayList<Storage.BlobWriteOption> optionList = new ArrayList<Storage.BlobWriteOption>();
            BlobInfo.Builder blobInfoBuilder = BlobInfo.newBuilder((String)this.bucketName, (String)newFileKey);
            this.setMetadata(blobInfoBuilder, fileInfo, optionList);
            Storage client = this.getClient();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                byte[] thumbnailBytes;
                client.createFrom(blobInfoBuilder.build(), (InputStream)in, optionList.toArray(new Storage.BlobWriteOption[0]));
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    ArrayList<Storage.BlobWriteOption> thOptionList = new ArrayList<Storage.BlobWriteOption>();
                    BlobInfo.Builder thBlobInfoBuilder = BlobInfo.newBuilder((String)this.bucketName, (String)newThFileKey);
                    this.setThMetadata(thBlobInfoBuilder, fileInfo, thOptionList);
                    client.createFrom(thBlobInfoBuilder.build(), (InputStream)new ByteArrayInputStream(thumbnailBytes), thOptionList.toArray(new Storage.BlobWriteOption[0]));
                }
                bl = true;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        this.checkAndDelete(newFileKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return bl;
    }

    public AclWrapper getAcl(Object acl) {
        if (acl instanceof Storage.PredefinedAcl) {
            return new AclWrapper((Storage.PredefinedAcl)acl);
        }
        if (acl instanceof String || acl == null) {
            String sAcl = (String)acl;
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                sAcl = this.defaultAcl;
            }
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                return null;
            }
            sAcl = sAcl.replace("-", "_");
            for (Storage.PredefinedAcl item2 : Storage.PredefinedAcl.values()) {
                if (!item2.toString().equalsIgnoreCase(sAcl)) continue;
                return new AclWrapper(item2);
            }
            return null;
        }
        if (acl instanceof Acl) {
            return new AclWrapper(Collections.singletonList((Acl)acl));
        }
        if (acl instanceof Collection) {
            List<Acl> aclList = ((Collection)acl).stream().map(item -> {
                if (item instanceof Acl) {
                    return (Acl)item;
                }
                throw new FileStorageRuntimeException("\u4e0d\u652f\u6301\u7684ACL\uff1a" + item);
            }).collect(Collectors.toList());
            return new AclWrapper(aclList);
        }
        throw ExceptionFactory.unrecognizedAcl(acl, this.platform);
    }

    public void setMetadata(BlobInfo.Builder blobInfoBuilder, FileInfo fileInfo, ArrayList<Storage.BlobWriteOption> optionList) {
        AclWrapper fileAcl;
        blobInfoBuilder.setContentType(fileInfo.getContentType()).setMetadata(fileInfo.getUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getMetadata())) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(fileInfo.getMetadata(), (Object)blobInfoBuilder, (CopyOptions)copyOptions);
        }
        if ((fileAcl = this.getAcl(fileInfo.getFileAcl())) != null) {
            if (fileAcl.getAclList() != null) {
                blobInfoBuilder.setAcl(fileAcl.getAclList());
            } else if (fileAcl.getPredefinedAcl() != null) {
                optionList.add(Storage.BlobWriteOption.predefinedAcl((Storage.PredefinedAcl)fileAcl.getPredefinedAcl()));
            }
        }
    }

    public void setThMetadata(BlobInfo.Builder blobInfoBuilder, FileInfo fileInfo, ArrayList<Storage.BlobWriteOption> optionList) {
        AclWrapper fileAcl;
        blobInfoBuilder.setContentType(fileInfo.getThContentType()).setMetadata(fileInfo.getThUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getThMetadata())) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(fileInfo.getThMetadata(), (Object)blobInfoBuilder, (CopyOptions)copyOptions);
        }
        if ((fileAcl = this.getAcl(fileInfo.getThFileAcl())) != null) {
            if (fileAcl.getAclList() != null) {
                blobInfoBuilder.setAcl(fileAcl.getAclList());
            } else if (fileAcl.getPredefinedAcl() != null) {
                optionList.add(Storage.BlobWriteOption.predefinedAcl((Storage.PredefinedAcl)fileAcl.getPredefinedAcl()));
            }
        }
    }

    @Override
    public boolean isSupportAcl() {
        return true;
    }

    @Override
    public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        AclWrapper oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            BlobInfo.Builder builder = BlobInfo.newBuilder((String)this.bucketName, (String)this.getFileKey(fileInfo));
            if (oAcl.getAclList() != null) {
                builder.setAcl(oAcl.getAclList());
                this.getClient().update(builder.build());
                return true;
            }
            if (oAcl.getPredefinedAcl() != null) {
                this.getClient().update(builder.build(), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.predefinedAcl((Storage.PredefinedAcl)oAcl.getPredefinedAcl())});
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw ExceptionFactory.setFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        AclWrapper oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            BlobInfo.Builder builder = BlobInfo.newBuilder((String)this.bucketName, (String)this.getThFileKey(fileInfo));
            if (oAcl.getAclList() != null) {
                builder.setAcl(oAcl.getAclList());
                this.getClient().update(builder.build());
                return true;
            }
            if (oAcl.getPredefinedAcl() != null) {
                this.getClient().update(builder.build(), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.predefinedAcl((Storage.PredefinedAcl)oAcl.getPredefinedAcl())});
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw ExceptionFactory.setThFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    @Override
    public String generatePresignedUrl(FileInfo fileInfo, Date expiration) {
        try {
            BlobInfo blobInfo = BlobInfo.newBuilder((String)this.bucketName, (String)this.getFileKey(fileInfo)).build();
            long duration = expiration.getTime() - System.currentTimeMillis();
            return this.getClient().signUrl(blobInfo, duration, TimeUnit.MILLISECONDS, new Storage.SignUrlOption[0]).toString();
        }
        catch (Exception e) {
            throw ExceptionFactory.generatePresignedUrl(fileInfo, this.platform, e);
        }
    }

    @Override
    public String generateThPresignedUrl(FileInfo fileInfo, Date expiration) {
        try {
            BlobInfo blobInfo = BlobInfo.newBuilder((String)this.bucketName, (String)this.getThFileKey(fileInfo)).build();
            long duration = expiration.getTime() - System.currentTimeMillis();
            return this.getClient().signUrl(blobInfo, duration, TimeUnit.MILLISECONDS, new Storage.SignUrlOption[0]).toString();
        }
        catch (Exception e) {
            throw ExceptionFactory.generateThPresignedUrl(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    protected void checkAndDelete(String fileKey) {
        Storage client = this.getClient();
        Blob blob = client.get(this.bucketName, fileKey, new Storage.BlobGetOption[0]);
        if (blob != null) {
            Storage.BlobSourceOption precondition = Storage.BlobSourceOption.generationMatch((long)blob.getGeneration());
            client.delete(this.bucketName, fileKey, new Storage.BlobSourceOption[]{precondition});
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        try {
            if (fileInfo.getThFilename() != null) {
                this.checkAndDelete(this.getThFileKey(fileInfo));
            }
            this.checkAndDelete(this.getFileKey(fileInfo));
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            Storage client = this.getClient();
            BlobId blobId = BlobId.of((String)this.bucketName, (String)this.getFileKey(fileInfo));
            return client.get(blobId) != null;
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Storage client = this.getClient();
        BlobId blobId = BlobId.of((String)this.bucketName, (String)this.getFileKey(fileInfo));
        try (ReadChannel readChannel = client.reader(blobId, new Storage.BlobSourceOption[0]);
             InputStream in = Channels.newInputStream((ReadableByteChannel)readChannel);){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        Storage client = this.getClient();
        BlobId thBlobId = BlobId.of((String)this.bucketName, (String)this.getThFileKey(fileInfo));
        try (ReadChannel readChannel = client.reader(thBlobId, new Storage.BlobSourceOption[0]);
             InputStream in = Channels.newInputStream((ReadableByteChannel)readChannel);){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        Blob srcFile;
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        Storage client = this.getClient();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            srcFile = client.get(this.bucketName, srcFileKey, new Storage.BlobGetOption[0]);
            if (srcFile == null) {
                throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, null);
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                client.copy(Storage.CopyRequest.newBuilder().setSource(BlobId.of((String)this.bucketName, (String)this.getThFileKey(srcFileInfo))).setTarget(BlobId.of((String)this.bucketName, (String)destThFileKey)).build()).getResult();
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        try {
            ProgressListener.quickStart(pre.getProgressListener(), srcFile.getSize());
            client.copy(Storage.CopyRequest.newBuilder().setSource(BlobId.of((String)this.bucketName, (String)srcFileKey)).setTarget(BlobId.of((String)this.bucketName, (String)destFileKey)).build()).getResult();
            ProgressListener.quickFinish(pre.getProgressListener(), srcFile.getSize());
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    this.checkAndDelete(destThFileKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.checkAndDelete(destFileKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getCredentialsPath() {
        return this.credentialsPath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDefaultAcl() {
        return this.defaultAcl;
    }

    public FileStorageClientFactory<Storage> getClientFactory() {
        return this.clientFactory;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setCredentialsPath(String credentialsPath) {
        this.credentialsPath = credentialsPath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setDefaultAcl(String defaultAcl) {
        this.defaultAcl = defaultAcl;
    }

    public void setClientFactory(FileStorageClientFactory<Storage> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public GoogleCloudStorageFileStorage() {
    }

    public static class AclWrapper {
        private List<Acl> aclList;
        private Storage.PredefinedAcl predefinedAcl;

        public AclWrapper(List<Acl> aclList) {
            this.aclList = aclList;
        }

        public AclWrapper(Storage.PredefinedAcl predefinedAcl) {
            this.predefinedAcl = predefinedAcl;
        }

        public List<Acl> getAclList() {
            return this.aclList;
        }

        public Storage.PredefinedAcl getPredefinedAcl() {
            return this.predefinedAcl;
        }

        public void setAclList(List<Acl> aclList) {
            this.aclList = aclList;
        }

        public void setPredefinedAcl(Storage.PredefinedAcl predefinedAcl) {
            this.predefinedAcl = predefinedAcl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AclWrapper)) {
                return false;
            }
            AclWrapper other = (AclWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Acl> this$aclList = this.getAclList();
            List<Acl> other$aclList = other.getAclList();
            if (this$aclList == null ? other$aclList != null : !((Object)this$aclList).equals(other$aclList)) {
                return false;
            }
            Storage.PredefinedAcl this$predefinedAcl = this.getPredefinedAcl();
            Storage.PredefinedAcl other$predefinedAcl = other.getPredefinedAcl();
            return !(this$predefinedAcl == null ? other$predefinedAcl != null : !this$predefinedAcl.equals(other$predefinedAcl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AclWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Acl> $aclList = this.getAclList();
            result = result * 59 + ($aclList == null ? 43 : ((Object)$aclList).hashCode());
            Storage.PredefinedAcl $predefinedAcl = this.getPredefinedAcl();
            result = result * 59 + ($predefinedAcl == null ? 43 : $predefinedAcl.hashCode());
            return result;
        }

        public String toString() {
            return "GoogleCloudStorageFileStorage.AclWrapper(aclList=" + this.aclList + ", predefinedAcl=" + this.predefinedAcl + ")";
        }
    }
}

