/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.util.StrUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.function.Consumer;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

public interface FileStorage
extends AutoCloseable {
    public String getPlatform();

    public void setPlatform(String var1);

    public boolean save(FileInfo var1, UploadPretreatment var2);

    default public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.notSupport();
    }

    default public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
    }

    default public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        return null;
    }

    default public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
    }

    default public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
    }

    default public FilePartInfoList listParts(ListPartsPretreatment pre) {
        return null;
    }

    default public boolean isSupportPresignedUrl() {
        return false;
    }

    default public String generatePresignedUrl(FileInfo fileInfo, Date expiration) {
        return null;
    }

    default public String generateThPresignedUrl(FileInfo fileInfo, Date expiration) {
        return null;
    }

    default public boolean isSupportAcl() {
        return false;
    }

    default public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        return false;
    }

    default public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        return false;
    }

    default public boolean isSupportMetadata() {
        return false;
    }

    public boolean delete(FileInfo var1);

    public boolean exists(FileInfo var1);

    public void download(FileInfo var1, Consumer<InputStream> var2);

    public void downloadTh(FileInfo var1, Consumer<InputStream> var2);

    default public boolean isSupportSameCopy() {
        return false;
    }

    default public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
    }

    default public boolean isSupportSameMove() {
        return false;
    }

    default public void sameMove(FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
    }

    @Override
    default public void close() {
    }

    default public String getFileKey(FileInfo fileInfo) {
        return Tools.getNotNull(fileInfo.getBasePath(), "") + Tools.getNotNull(fileInfo.getPath(), "") + Tools.getNotNull(fileInfo.getFilename(), "");
    }

    default public String getThFileKey(FileInfo fileInfo) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            return null;
        }
        return Tools.getNotNull(fileInfo.getBasePath(), "") + Tools.getNotNull(fileInfo.getPath(), "") + Tools.getNotNull(fileInfo.getThFilename(), "");
    }
}

