/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.models.BlobCopyInfo;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import com.azure.storage.blob.options.BlockBlobCommitBlockListOptions;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.models.PathAccessControlEntry;
import com.azure.storage.file.datalake.models.PathPermissions;
import com.azure.storage.file.datalake.models.RolePermissions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.platform.AzureBlobStorageFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

public class AzureBlobStorageFileStorage
implements FileStorage {
    private String platform;
    private String containerName;
    private String domain;
    private String basePath;
    private String defaultAcl;
    private Long multipartThreshold;
    private Long multipartPartSize;
    private Integer maxConcurrency;
    private FileStorageClientFactory<AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient> clientFactory;

    public AzureBlobStorageFileStorage(FileStorageProperties.AzureBlobStorageConfig config, FileStorageClientFactory<AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient> clientFactory) {
        this.platform = config.getPlatform();
        this.containerName = config.getContainerName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.defaultAcl = config.getDefaultAcl();
        this.multipartThreshold = config.getMultipartThreshold();
        this.multipartPartSize = config.getMultipartPartSize();
        this.maxConcurrency = config.getMaxConcurrency();
        this.clientFactory = clientFactory;
    }

    public AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient getClient() {
        return this.clientFactory.getClient();
    }

    public BlobClient getBlobClient(String fileKey) {
        if (StrUtil.isBlank((CharSequence)fileKey)) {
            return null;
        }
        return this.getClient().getBlobServiceClient().getBlobContainerClient(this.containerName).getBlobClient(fileKey);
    }

    public DataLakeFileClient getDataLakeFileClient(String fileKey) {
        return this.getClient().getDataLakeServiceClient().getFileSystemClient(this.containerName).getFileClient(fileKey);
    }

    public String getUrl(String fileKey) {
        return this.domain + this.containerName + "/" + fileKey;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block16: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.getUrl(newFileKey));
            AclWrapper acl = this.getAcl(fileInfo.getFileAcl());
            ProgressListener listener = pre.getProgressListener();
            BlobClient blobClient = this.getBlobClient(newFileKey);
            BlobClient thBlobClient = null;
            InputStreamPlus in = pre.getInputStreamPlus(false);
            try {
                byte[] thumbnailBytes;
                BlobParallelUploadOptions options = new BlobParallelUploadOptions((InputStream)in);
                options.setMetadata(fileInfo.getUserMetadata());
                options.setHeaders(this.getBlobHttpHeaders(fileInfo.getContentType(), fileInfo.getMetadata()));
                options.setParallelTransferOptions(new ParallelTransferOptions().setBlockSizeLong(this.multipartPartSize).setMaxConcurrency(this.maxConcurrency).setMaxSingleUploadSizeLong(this.multipartThreshold));
                if (listener != null) {
                    options.getParallelTransferOptions().setProgressListener(progressSize -> listener.progress(progressSize, fileInfo.getSize()));
                }
                ProgressListener.quickStart(listener, fileInfo.getSize());
                blobClient.uploadWithResponse(options, null, Context.NONE);
                this.setFileAcl(newFileKey, acl);
                ProgressListener.quickFinish(listener);
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.getUrl(newThFileKey));
                    AclWrapper thAcl = this.getAcl(fileInfo.getThFileAcl());
                    BlobParallelUploadOptions thOptions = new BlobParallelUploadOptions((InputStream)new ByteArrayInputStream(thumbnailBytes));
                    thOptions.setMetadata(fileInfo.getThUserMetadata());
                    thOptions.setHeaders(this.getBlobHttpHeaders(fileInfo.getThContentType(), fileInfo.getThMetadata()));
                    thBlobClient = this.getBlobClient(newThFileKey);
                    thBlobClient.uploadWithResponse(thOptions, null, Context.NONE);
                    this.setFileAcl(newFileKey, thAcl);
                }
                bl = true;
                if (in == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        blobClient.deleteIfExists();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (thBlobClient != null) {
                        try {
                            thBlobClient.deleteIfExists();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll().setListPartsSupportMaxParts(50000);
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.getUrl(newFileKey));
        fileInfo.setUploadId(IdUtil.objectId());
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block9: {
            FileInfo fileInfo = pre.getFileInfo();
            BlockBlobClient blobClient = this.getBlobClient(this.getFileKey(fileInfo)).getBlockBlobClient();
            FileWrapper partFileWrapper = pre.getPartFileWrapper();
            Long partSize = partFileWrapper.getSize();
            pre.setHashCalculatorMd5();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                if (partSize == null) {
                    partSize = partFileWrapper.getInputStreamMaskResetReturn(Tools::getSize);
                }
                String blockIdBase64 = Base64.encode((CharSequence)String.format("%06d", pre.getPartNumber()));
                blobClient.stageBlock(blockIdBase64, (InputStream)in, partSize.longValue());
                String etag = pre.getHashCalculatorManager().getHashInfo().getMd5();
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(etag);
                filePartInfo2.setPartNumber(pre.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        AclWrapper acl = this.getAcl(fileInfo.getFileAcl());
        BlockBlobClient client = this.getBlobClient(newFileKey).getBlockBlobClient();
        try {
            List partList = pre.getPartInfoList().stream().sorted(Comparator.comparingInt(FilePartInfo::getPartNumber)).map(p -> Base64.encode((CharSequence)String.format("%06d", p.getPartNumber()))).collect(Collectors.toList());
            BlockBlobCommitBlockListOptions options = new BlockBlobCommitBlockListOptions(partList);
            options.setMetadata(fileInfo.getUserMetadata());
            options.setHeaders(this.getBlobHttpHeaders(fileInfo.getContentType(), fileInfo.getMetadata()));
            this.setFileAcl(newFileKey, acl);
            client.commitBlockListWithResponse(options, null, Context.NONE).getValue();
            if (fileInfo.getSize() == null) {
                fileInfo.setSize(client.getProperties().getBlobSize());
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        try {
            this.getBlobClient(this.getFileKey(fileInfo)).getBlockBlobClient().deleteIfExists();
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        BlockBlobClient client = this.getBlobClient(this.getFileKey(fileInfo)).getBlockBlobClient();
        try {
            BlockList blockList = client.listBlocks(BlockListType.UNCOMMITTED);
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            list.setList(blockList.getUncommittedBlocks().stream().map(p -> {
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setPartSize(p.getSizeLong());
                filePartInfo.setPartNumber(Integer.parseInt(Base64.decodeStr((CharSequence)p.getName())));
                return filePartInfo;
            }).collect(Collectors.toList()));
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportAcl() {
        return true;
    }

    public AclWrapper getAcl(Object acl) {
        if (acl instanceof PathPermissions) {
            return new AclWrapper((PathPermissions)acl);
        }
        if (acl instanceof String || acl == null) {
            String sAcl = (String)acl;
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                sAcl = this.defaultAcl;
            }
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                return null;
            }
            if ("private".equalsIgnoreCase(sAcl)) {
                return new AclWrapper(new PathPermissions().setGroup(new RolePermissions().setReadPermission(true)).setOwner(new RolePermissions().setReadPermission(true).setWritePermission(true)));
            }
            if ("public-read".equalsIgnoreCase(sAcl)) {
                return new AclWrapper(new PathPermissions().setGroup(new RolePermissions().setReadPermission(true)).setOwner(new RolePermissions().setReadPermission(true).setWritePermission(true)).setOther(new RolePermissions().setReadPermission(true)));
            }
            if ("public-read-write".equalsIgnoreCase(sAcl)) {
                return new AclWrapper(new PathPermissions().setGroup(new RolePermissions().setReadPermission(true).setWritePermission(true)).setOwner(new RolePermissions().setReadPermission(true).setWritePermission(true)).setOther(new RolePermissions().setReadPermission(true).setWritePermission(true)));
            }
        } else {
            if (acl instanceof PathAccessControlEntry) {
                return new AclWrapper(Collections.singletonList((PathAccessControlEntry)acl));
            }
            if (acl instanceof Collection) {
                List<PathAccessControlEntry> aclList = ((Collection)acl).stream().map(item -> {
                    if (item instanceof PathAccessControlEntry) {
                        return (PathAccessControlEntry)item;
                    }
                    throw new FileStorageRuntimeException("\u4e0d\u652f\u6301\u7684ACL\uff1a" + item);
                }).collect(Collectors.toList());
                return new AclWrapper(aclList);
            }
        }
        throw ExceptionFactory.unrecognizedAcl(acl, this.platform);
    }

    public void setFileAcl(String fileKey, AclWrapper acl) {
        if (acl == null) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)fileKey)) {
            return;
        }
        DataLakeFileClient fileClient = this.getDataLakeFileClient(fileKey);
        if (acl.getPermissions() != null) {
            fileClient.setPermissions(acl.getPermissions(), null, null);
        } else if (acl.getAclList() != null) {
            fileClient.setAccessControlList(acl.getAclList(), null, null);
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        AclWrapper oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            this.setFileAcl(this.getFileKey(fileInfo), oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        AclWrapper oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            this.setFileAcl(this.getThFileKey(fileInfo), oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setThFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    public BlobHttpHeaders getBlobHttpHeaders(String contentType, Map<String, String> metadata) {
        BlobHttpHeaders headers = new BlobHttpHeaders();
        if (StrUtil.isNotBlank((CharSequence)contentType)) {
            headers.setContentType(contentType);
        }
        if (CollUtil.isNotEmpty(metadata)) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(metadata, (Object)headers, (CopyOptions)copyOptions);
        }
        return headers;
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        try {
            if (fileInfo.getThFilename() != null) {
                this.getBlobClient(this.getThFileKey(fileInfo)).deleteIfExists();
            }
            this.getBlobClient(this.getFileKey(fileInfo)).deleteIfExists();
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.getBlobClient(this.getFileKey(fileInfo)).exists();
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        BlobClient blobClient = this.getBlobClient(this.getFileKey(fileInfo));
        try (BlobInputStream in = blobClient.openInputStream();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        BlobClient blobClient = this.getBlobClient(this.getThFileKey(fileInfo));
        try (BlobInputStream in = blobClient.openInputStream();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    @Override
    public String generatePresignedUrl(FileInfo fileInfo, Date expiration) {
        try {
            BlobClient blobClient = this.getBlobClient(this.getFileKey(fileInfo));
            return blobClient.getBlobUrl() + "?" + blobClient.generateSas(this.getBlobServiceSasSignatureValues(expiration));
        }
        catch (Exception e) {
            throw ExceptionFactory.generatePresignedUrl(fileInfo, this.platform, e);
        }
    }

    @Override
    public String generateThPresignedUrl(FileInfo fileInfo, Date expiration) {
        try {
            String key = this.getThFileKey(fileInfo);
            if (key == null) {
                return null;
            }
            BlobClient thBlobClient = this.getBlobClient(this.getThFileKey(fileInfo));
            return thBlobClient.getBlobUrl() + "?" + thBlobClient.generateSas(this.getBlobServiceSasSignatureValues(expiration));
        }
        catch (Exception e) {
            throw ExceptionFactory.generateThPresignedUrl(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    public void awaitCopy(SyncPoller<BlobCopyInfo, Void> copySyncPoller) {
        PollResponse copyInfo;
        CopyStatusType copyStatus;
        while ((copyStatus = ((BlobCopyInfo)(copyInfo = copySyncPoller.poll()).getValue()).getCopyStatus()) == CopyStatusType.PENDING) {
        }
        if (copyStatus != CopyStatusType.SUCCESS) {
            throw new RuntimeException(copyStatus.toString());
        }
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        Check.sameCopyNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        String destFileKey = this.getFileKey(destFileInfo);
        String destThFileKey = this.getThFileKey(destFileInfo);
        BlobClient srcClient = this.getBlobClient(this.getFileKey(srcFileInfo));
        BlobClient destClient = this.getBlobClient(destFileKey);
        BlobClient srcThClient = this.getBlobClient(this.getThFileKey(srcFileInfo));
        BlobClient destThClient = this.getBlobClient(destThFileKey);
        if (!Boolean.TRUE.equals(srcClient.exists())) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, null);
        }
        if (destThClient != null) {
            destFileInfo.setThUrl(this.getUrl(destThFileKey));
            try {
                this.awaitCopy((SyncPoller<BlobCopyInfo, Void>)destThClient.beginCopy(srcThClient.getBlobUrl(), Duration.ofSeconds(1L)));
                this.setFileAcl(destThFileKey, this.getAcl(srcFileInfo.getThFileAcl()));
            }
            catch (Exception e) {
                try {
                    destThClient.deleteIfExists();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        destFileInfo.setUrl(this.getUrl(destFileKey));
        try {
            long size = srcClient.getProperties().getBlobSize();
            ProgressListener.quickStart(pre.getProgressListener(), size);
            this.awaitCopy((SyncPoller<BlobCopyInfo, Void>)destClient.beginCopy(srcClient.getBlobUrl(), Duration.ofSeconds(1L)));
            this.setFileAcl(destFileKey, this.getAcl(srcFileInfo.getFileAcl()));
            ProgressListener.quickFinish(pre.getProgressListener(), size);
        }
        catch (Exception e) {
            if (destThClient != null) {
                try {
                    destThClient.deleteIfExists();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                destClient.deleteIfExists();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    private BlobServiceSasSignatureValues getBlobServiceSasSignatureValues(Date expiration) {
        BlobSasPermission blobPermission = new BlobSasPermission().setReadPermission(true);
        OffsetDateTime offsetDateTime = expiration.toInstant().atZone(ZoneOffset.UTC).toOffsetDateTime();
        return new BlobServiceSasSignatureValues(offsetDateTime, blobPermission);
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getDefaultAcl() {
        return this.defaultAcl;
    }

    public Long getMultipartThreshold() {
        return this.multipartThreshold;
    }

    public Long getMultipartPartSize() {
        return this.multipartPartSize;
    }

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public FileStorageClientFactory<AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setDefaultAcl(String defaultAcl) {
        this.defaultAcl = defaultAcl;
    }

    public void setMultipartThreshold(Long multipartThreshold) {
        this.multipartThreshold = multipartThreshold;
    }

    public void setMultipartPartSize(Long multipartPartSize) {
        this.multipartPartSize = multipartPartSize;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public void setClientFactory(FileStorageClientFactory<AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public AzureBlobStorageFileStorage() {
    }

    public static class AclWrapper {
        private List<PathAccessControlEntry> aclList;
        private PathPermissions permissions;

        public AclWrapper(List<PathAccessControlEntry> aclList) {
            this.aclList = aclList;
        }

        public AclWrapper(PathPermissions permissions) {
            this.permissions = permissions;
        }

        public List<PathAccessControlEntry> getAclList() {
            return this.aclList;
        }

        public PathPermissions getPermissions() {
            return this.permissions;
        }

        public void setAclList(List<PathAccessControlEntry> aclList) {
            this.aclList = aclList;
        }

        public void setPermissions(PathPermissions permissions) {
            this.permissions = permissions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AclWrapper)) {
                return false;
            }
            AclWrapper other = (AclWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<PathAccessControlEntry> this$aclList = this.getAclList();
            List<PathAccessControlEntry> other$aclList = other.getAclList();
            if (this$aclList == null ? other$aclList != null : !((Object)this$aclList).equals(other$aclList)) {
                return false;
            }
            PathPermissions this$permissions = this.getPermissions();
            PathPermissions other$permissions = other.getPermissions();
            return !(this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AclWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<PathAccessControlEntry> $aclList = this.getAclList();
            result = result * 59 + ($aclList == null ? 43 : ((Object)$aclList).hashCode());
            PathPermissions $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : $permissions.hashCode());
            return result;
        }

        public String toString() {
            return "AzureBlobStorageFileStorage.AclWrapper(aclList=" + this.aclList + ", permissions=" + this.permissions + ")";
        }
    }
}

