/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

public class AmazonS3FileStorage
implements FileStorage {
    private String platform;
    private String bucketName;
    private String domain;
    private String basePath;
    private String defaultAcl;
    private int multipartThreshold;
    private int multipartPartSize;
    private FileStorageClientFactory<AmazonS3> clientFactory;

    public AmazonS3FileStorage(FileStorageProperties.AmazonS3Config config, FileStorageClientFactory<AmazonS3> clientFactory) {
        this.platform = config.getPlatform();
        this.bucketName = config.getBucketName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.defaultAcl = config.getDefaultAcl();
        this.multipartThreshold = config.getMultipartThreshold();
        this.multipartPartSize = config.getMultipartPartSize();
        this.clientFactory = clientFactory;
    }

    public AmazonS3 getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block22: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            CannedAccessControlList fileAcl = this.getAcl(fileInfo.getFileAcl());
            ObjectMetadata metadata = this.getObjectMetadata(fileInfo);
            ProgressListener listener = pre.getProgressListener();
            AmazonS3 client = this.getClient();
            boolean useMultipartUpload = fileInfo.getSize() == null || fileInfo.getSize() >= (long)this.multipartThreshold;
            String uploadId = null;
            InputStreamPlus in = pre.getInputStreamPlus(false);
            try {
                byte[] thumbnailBytes;
                AtomicLong progressSize;
                if (useMultipartUpload) {
                    byte[] bytes;
                    uploadId = client.initiateMultipartUpload(new InitiateMultipartUploadRequest(this.bucketName, newFileKey, metadata)).getUploadId();
                    ArrayList<PartETag> partList = new ArrayList<PartETag>();
                    int i = 0;
                    progressSize = new AtomicLong();
                    if (listener != null) {
                        listener.start();
                    }
                    while ((bytes = IoUtil.readBytes((InputStream)in, (int)this.multipartPartSize)) != null && bytes.length != 0) {
                        UploadPartRequest part = new UploadPartRequest();
                        part.setBucketName(this.bucketName);
                        part.setKey(newFileKey);
                        part.setUploadId(uploadId);
                        part.setInputStream((InputStream)new ByteArrayInputStream(bytes));
                        part.setPartSize((long)bytes.length);
                        part.setPartNumber(++i);
                        if (listener != null) {
                            part.setGeneralProgressListener(e -> {
                                if (e.getEventType() == ProgressEventType.REQUEST_BYTE_TRANSFER_EVENT) {
                                    listener.progress(progressSize.addAndGet(e.getBytes()), fileInfo.getSize());
                                }
                            });
                        }
                        partList.add(client.uploadPart(part).getPartETag());
                    }
                    client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, newFileKey, uploadId, partList));
                    if (fileAcl != null) {
                        client.setObjectAcl(this.bucketName, newFileKey, fileAcl);
                    }
                    if (listener != null) {
                        listener.finish();
                    }
                } else {
                    BufferedInputStream bin = new BufferedInputStream(in, 131073);
                    PutObjectRequest request = new PutObjectRequest(this.bucketName, newFileKey, (InputStream)bin, metadata);
                    request.setCannedAcl(fileAcl);
                    if (listener != null) {
                        progressSize = new AtomicLong();
                        request.setGeneralProgressListener(e -> {
                            if (e.getEventType() == ProgressEventType.TRANSFER_STARTED_EVENT) {
                                listener.start();
                            } else if (e.getEventType() == ProgressEventType.REQUEST_BYTE_TRANSFER_EVENT) {
                                listener.progress(progressSize.addAndGet(e.getBytes()), fileInfo.getSize());
                            } else if (e.getEventType() == ProgressEventType.TRANSFER_COMPLETED_EVENT) {
                                listener.finish();
                            }
                        });
                    }
                    client.putObject(request);
                }
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    PutObjectRequest request = new PutObjectRequest(this.bucketName, newThFileKey, (InputStream)new ByteArrayInputStream(thumbnailBytes), this.getThObjectMetadata(fileInfo));
                    request.setCannedAcl(this.getAcl(fileInfo.getThFileAcl()));
                    client.putObject(request);
                }
                bl = true;
                if (in == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    try {
                        if (useMultipartUpload) {
                            client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, newFileKey, uploadId));
                        } else {
                            client.deleteObject(this.bucketName, newFileKey);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e2);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll();
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        ObjectMetadata metadata = this.getObjectMetadata(fileInfo);
        AmazonS3 client = this.getClient();
        try {
            String uploadId = client.initiateMultipartUpload(new InitiateMultipartUploadRequest(this.bucketName, newFileKey, metadata)).getUploadId();
            fileInfo.setUploadId(uploadId);
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block9: {
            FileInfo fileInfo = pre.getFileInfo();
            String newFileKey = this.getFileKey(fileInfo);
            AmazonS3 client = this.getClient();
            FileWrapper partFileWrapper = pre.getPartFileWrapper();
            Long partSize = partFileWrapper.getSize();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                if (partSize == null) {
                    partSize = partFileWrapper.getInputStreamMaskResetReturn(Tools::getSize);
                }
                UploadPartRequest part = new UploadPartRequest();
                part.setBucketName(this.bucketName);
                part.setKey(newFileKey);
                part.setUploadId(fileInfo.getUploadId());
                part.setInputStream((InputStream)in);
                part.setPartSize(partSize.longValue());
                part.setPartNumber(pre.getPartNumber());
                PartETag partETag = client.uploadPart(part).getPartETag();
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(partETag.getETag());
                filePartInfo2.setPartNumber(partETag.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        CannedAccessControlList fileAcl = this.getAcl(fileInfo.getFileAcl());
        AmazonS3 client = this.getClient();
        try {
            List partList = pre.getPartInfoList().stream().map(part -> new PartETag(part.getPartNumber().intValue(), part.getETag())).collect(Collectors.toList());
            ProgressListener.quickStart(pre.getProgressListener(), fileInfo.getSize());
            client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, newFileKey, fileInfo.getUploadId(), partList));
            if (fileAcl != null) {
                client.setObjectAcl(this.bucketName, newFileKey, fileAcl);
            }
            ProgressListener.quickFinish(pre.getProgressListener(), fileInfo.getSize());
        }
        catch (Exception e) {
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        AmazonS3 client = this.getClient();
        try {
            client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, newFileKey, fileInfo.getUploadId()));
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        AmazonS3 client = this.getClient();
        try {
            ListPartsRequest request = new ListPartsRequest(this.bucketName, newFileKey, fileInfo.getUploadId());
            request.setMaxParts(pre.getMaxParts().intValue());
            request.setPartNumberMarker(pre.getPartNumberMarker());
            PartListing result = client.listParts(request);
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            list.setList(result.getParts().stream().map(p -> {
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setETag(p.getETag());
                filePartInfo.setPartNumber(p.getPartNumber());
                filePartInfo.setPartSize(p.getSize());
                filePartInfo.setLastModified(p.getLastModified());
                return filePartInfo;
            }).collect(Collectors.toList()));
            list.setMaxParts(result.getMaxParts());
            list.setIsTruncated(result.isTruncated());
            list.setPartNumberMarker(result.getPartNumberMarker());
            list.setNextPartNumberMarker(result.getNextPartNumberMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    public CannedAccessControlList getAcl(Object acl) {
        if (acl instanceof CannedAccessControlList) {
            return (CannedAccessControlList)acl;
        }
        if (acl instanceof String || acl == null) {
            String sAcl = (String)acl;
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                sAcl = this.defaultAcl;
            }
            for (CannedAccessControlList item : CannedAccessControlList.values()) {
                if (!item.toString().equals(sAcl)) continue;
                return item;
            }
            return null;
        }
        throw ExceptionFactory.unrecognizedAcl(acl, this.platform);
    }

    public ObjectMetadata getObjectMetadata(FileInfo fileInfo) {
        ObjectMetadata metadata = new ObjectMetadata();
        if (fileInfo.getSize() != null) {
            metadata.setContentLength(fileInfo.getSize().longValue());
        }
        if (fileInfo.getContentType() != null) {
            metadata.setContentType(fileInfo.getContentType());
        }
        metadata.setUserMetadata(fileInfo.getUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getMetadata())) {
            fileInfo.getMetadata().forEach((arg_0, arg_1) -> ((ObjectMetadata)metadata).setHeader(arg_0, arg_1));
        }
        return metadata;
    }

    public ObjectMetadata getThObjectMetadata(FileInfo fileInfo) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(fileInfo.getThSize().longValue());
        metadata.setContentType(fileInfo.getThContentType());
        metadata.setUserMetadata(fileInfo.getThUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getThMetadata())) {
            fileInfo.getThMetadata().forEach((arg_0, arg_1) -> ((ObjectMetadata)metadata).setHeader(arg_0, arg_1));
        }
        return metadata;
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    @Override
    public String generatePresignedUrl(FileInfo fileInfo, Date expiration) {
        try {
            return this.getClient().generatePresignedUrl(this.bucketName, this.getFileKey(fileInfo), expiration).toString();
        }
        catch (Exception e) {
            throw ExceptionFactory.generatePresignedUrl(fileInfo, this.platform, e);
        }
    }

    @Override
    public String generateThPresignedUrl(FileInfo fileInfo, Date expiration) {
        try {
            String key = this.getThFileKey(fileInfo);
            if (key == null) {
                return null;
            }
            return this.getClient().generatePresignedUrl(this.bucketName, key, expiration).toString();
        }
        catch (Exception e) {
            throw ExceptionFactory.generateThPresignedUrl(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportAcl() {
        return true;
    }

    @Override
    public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        CannedAccessControlList oAcl = this.getAcl(acl);
        try {
            if (oAcl == null) {
                return false;
            }
            this.getClient().setObjectAcl(this.bucketName, this.getFileKey(fileInfo), oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        CannedAccessControlList oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        String key = this.getThFileKey(fileInfo);
        if (key == null) {
            return false;
        }
        try {
            this.getClient().setObjectAcl(this.bucketName, key, oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setThFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        AmazonS3 client = this.getClient();
        try {
            if (fileInfo.getThFilename() != null) {
                client.deleteObject(this.bucketName, this.getThFileKey(fileInfo));
            }
            client.deleteObject(this.bucketName, this.getFileKey(fileInfo));
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.getClient().doesObjectExist(this.bucketName, this.getFileKey(fileInfo));
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        S3Object object = this.getClient().getObject(this.bucketName, this.getFileKey(fileInfo));
        try (S3ObjectInputStream in = object.getObjectContent();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        S3Object object = this.getClient().getObject(this.bucketName, this.getThFileKey(fileInfo));
        try (S3ObjectInputStream in = object.getObjectContent();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        ObjectMetadata srcFile;
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        AmazonS3 client = this.getClient();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            srcFile = client.getObjectMetadata(this.bucketName, srcFileKey);
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                client.copyObject(new CopyObjectRequest(this.bucketName, this.getThFileKey(srcFileInfo), this.bucketName, destThFileKey).withCannedAccessControlList(this.getAcl(destFileInfo.getThFileAcl())));
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        long fileSize = srcFile.getContentLength();
        boolean useMultipartCopy = fileSize >= 0x40000000L;
        String uploadId = null;
        try {
            if (useMultipartCopy) {
                ObjectMetadata metadata = this.getObjectMetadata(destFileInfo);
                uploadId = client.initiateMultipartUpload(new InitiateMultipartUploadRequest(this.bucketName, destFileKey, metadata).withCannedACL(this.getAcl(destFileInfo.getFileAcl()))).getUploadId();
                ProgressListener.quickStart(pre.getProgressListener(), fileSize);
                ArrayList<PartETag> partList = new ArrayList<PartETag>();
                long progressSize = 0L;
                int i = 0;
                while (progressSize < fileSize) {
                    long partSize = Math.min(0x10000000L, fileSize - progressSize);
                    CopyPartRequest part = new CopyPartRequest();
                    part.setSourceBucketName(this.bucketName);
                    part.setSourceKey(srcFileKey);
                    part.setDestinationBucketName(this.bucketName);
                    part.setDestinationKey(destFileKey);
                    part.setUploadId(uploadId);
                    part.setFirstByte(Long.valueOf(progressSize));
                    part.setLastByte(Long.valueOf(progressSize + partSize - 1L));
                    part.setPartNumber(++i);
                    partList.add(client.copyPart(part).getPartETag());
                    ProgressListener.quickProgress(pre.getProgressListener(), progressSize += partSize, fileSize);
                }
                client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, destFileKey, uploadId, partList));
                ProgressListener.quickFinish(pre.getProgressListener());
            } else {
                ProgressListener.quickStart(pre.getProgressListener(), fileSize);
                client.copyObject(new CopyObjectRequest(this.bucketName, srcFileKey, this.bucketName, destFileKey).withCannedAccessControlList(this.getAcl(destFileInfo.getFileAcl())));
                ProgressListener.quickFinish(pre.getProgressListener(), fileSize);
            }
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    client.deleteObject(this.bucketName, destThFileKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (useMultipartCopy) {
                    client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, destFileKey, uploadId));
                } else {
                    client.deleteObject(this.bucketName, destFileKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getDefaultAcl() {
        return this.defaultAcl;
    }

    public int getMultipartThreshold() {
        return this.multipartThreshold;
    }

    public int getMultipartPartSize() {
        return this.multipartPartSize;
    }

    public FileStorageClientFactory<AmazonS3> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setDefaultAcl(String defaultAcl) {
        this.defaultAcl = defaultAcl;
    }

    public void setMultipartThreshold(int multipartThreshold) {
        this.multipartThreshold = multipartThreshold;
    }

    public void setMultipartPartSize(int multipartPartSize) {
        this.multipartPartSize = multipartPartSize;
    }

    public void setClientFactory(FileStorageClientFactory<AmazonS3> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public AmazonS3FileStorage() {
    }
}

