/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.file;

import org.dromara.x.file.storage.core.file.ByteFileWrapper;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.file.FileWrapperAdapter;
import org.dromara.x.file.storage.core.tika.ContentTypeDetect;

public class ByteFileWrapperAdapter
implements FileWrapperAdapter {
    private ContentTypeDetect contentTypeDetect;

    @Override
    public boolean isSupport(Object source) {
        return source instanceof byte[] || source instanceof ByteFileWrapper;
    }

    @Override
    public FileWrapper getFileWrapper(Object source, String name, String contentType, Long size) {
        if (source instanceof ByteFileWrapper) {
            return this.updateFileWrapper((ByteFileWrapper)source, name, contentType, size);
        }
        byte[] bytes = (byte[])source;
        if (name == null) {
            name = "";
        }
        if (contentType == null) {
            contentType = this.contentTypeDetect.detect(bytes, name);
        }
        if (size == null) {
            size = bytes.length;
        }
        return new ByteFileWrapper(bytes, name, contentType, size);
    }

    public ContentTypeDetect getContentTypeDetect() {
        return this.contentTypeDetect;
    }

    public void setContentTypeDetect(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
    }

    public ByteFileWrapperAdapter() {
    }

    public ByteFileWrapperAdapter(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
    }
}

