/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.copy;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dromara.x.file.storage.core.Downloader;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.CopyAspectChain;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.SameCopyAspectChain;
import org.dromara.x.file.storage.core.constant.Constant;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.hash.HashInfo;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;
import org.dromara.x.file.storage.core.upload.UploadPretreatment;

public class CopyActuator {
    private final FileStorageService fileStorageService;
    private final FileInfo fileInfo;
    private final CopyPretreatment pre;

    public CopyActuator(CopyPretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
        this.fileInfo = pre.getFileInfo();
    }

    public FileInfo execute() {
        return this.execute((FileStorage)this.fileStorageService.getFileStorageVerify(this.fileInfo.getPlatform()), this.fileStorageService.getFileRecorder(), (List<FileStorageAspect>)this.fileStorageService.getAspectList());
    }

    public FileInfo execute(FileStorage fileStorage, FileRecorder fileRecorder, List<FileStorageAspect> aspectList) {
        if (this.fileInfo == null) {
            throw new FileStorageRuntimeException("fileInfo \u4e0d\u80fd\u4e3a null");
        }
        if (this.fileInfo.getPlatform() == null) {
            throw new FileStorageRuntimeException("fileInfo \u7684 platform \u4e0d\u80fd\u4e3a null");
        }
        if (this.fileInfo.getPath() == null) {
            throw new FileStorageRuntimeException("fileInfo \u7684 path \u4e0d\u80fd\u4e3a null");
        }
        if (StrUtil.isBlank((CharSequence)this.fileInfo.getFilename())) {
            throw new FileStorageRuntimeException("fileInfo \u7684 filename \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNotBlank((CharSequence)this.fileInfo.getThFilename()) && StrUtil.isBlank((CharSequence)this.pre.getThFilename())) {
            throw new FileStorageRuntimeException("\u76ee\u6807\u7f29\u7565\u56fe\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new CopyAspectChain(aspectList, (_srcFileInfo, _pre, _fileStorage, _fileRecorder) -> {
            FileInfo destFileInfo = this.isSameCopy(_srcFileInfo, _pre, _fileStorage) ? this.sameCopy(_srcFileInfo, _pre, _fileStorage, _fileRecorder, aspectList) : this.crossCopy(_srcFileInfo, _pre, _fileStorage, _fileRecorder, aspectList);
            return destFileInfo;
        }).next(this.fileInfo, this.pre, fileStorage, fileRecorder);
    }

    protected boolean isSameCopy(FileInfo srcFileInfo, CopyPretreatment pre, FileStorage fileStorage) {
        Constant.CopyMode copyMode = pre.getCopyMode();
        if (copyMode == Constant.CopyMode.SAME) {
            if (!this.fileStorageService.isSupportSameCopy(fileStorage)) {
                throw new FileStorageRuntimeException("\u5b58\u50a8\u5e73\u53f0\u3010" + fileStorage.getPlatform() + "\u3011\u4e0d\u652f\u6301\u540c\u5b58\u50a8\u5e73\u53f0\u590d\u5236");
            }
            return true;
        }
        if (copyMode == Constant.CopyMode.CROSS) {
            return false;
        }
        return srcFileInfo.getPlatform().equals(pre.getPlatform()) && this.fileStorageService.isSupportSameCopy(fileStorage);
    }

    protected FileInfo sameCopy(FileInfo srcFileInfo, CopyPretreatment pre, FileStorage fileStorage, FileRecorder fileRecorder, List<FileStorageAspect> aspectList) {
        if ((srcFileInfo.getPath() + srcFileInfo.getFilename()).equals(pre.getPath() + pre.getFilename())) {
            throw new FileStorageRuntimeException("\u6e90\u6587\u4ef6\u4e0e\u76ee\u6807\u6587\u4ef6\u8def\u5f84\u76f8\u540c");
        }
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename()) && (srcFileInfo.getPath() + srcFileInfo.getThFilename()).equals(pre.getPath() + pre.getThFilename())) {
            throw new FileStorageRuntimeException("\u6e90\u7f29\u7565\u56fe\u6587\u4ef6\u4e0e\u76ee\u6807\u7f29\u7565\u56fe\u6587\u4ef6\u8def\u5f84\u76f8\u540c");
        }
        FileInfo destFileInfo = new FileInfo();
        destFileInfo.setSize(srcFileInfo.getSize());
        destFileInfo.setFilename(pre.getFilename());
        destFileInfo.setOriginalFilename(srcFileInfo.getOriginalFilename());
        destFileInfo.setBasePath(srcFileInfo.getBasePath());
        destFileInfo.setPath(pre.getPath());
        destFileInfo.setExt(FileNameUtil.extName((String)pre.getFilename()));
        destFileInfo.setContentType(srcFileInfo.getContentType());
        destFileInfo.setPlatform(pre.getPlatform());
        destFileInfo.setThFilename(pre.getThFilename());
        destFileInfo.setThSize(srcFileInfo.getThSize());
        destFileInfo.setThContentType(srcFileInfo.getThContentType());
        destFileInfo.setObjectId(srcFileInfo.getObjectId());
        destFileInfo.setObjectType(srcFileInfo.getObjectType());
        if (srcFileInfo.getMetadata() != null) {
            destFileInfo.setMetadata(new LinkedHashMap<String, String>(srcFileInfo.getMetadata()));
        }
        if (srcFileInfo.getUserMetadata() != null) {
            destFileInfo.setUserMetadata(new LinkedHashMap<String, String>(srcFileInfo.getUserMetadata()));
        }
        if (srcFileInfo.getThMetadata() != null) {
            destFileInfo.setThMetadata(new LinkedHashMap<String, String>(srcFileInfo.getThMetadata()));
        }
        if (srcFileInfo.getThUserMetadata() != null) {
            destFileInfo.setThUserMetadata(new LinkedHashMap<String, String>(srcFileInfo.getThUserMetadata()));
        }
        if (srcFileInfo.getAttr() != null) {
            destFileInfo.setAttr(new Dict((Map)srcFileInfo.getAttr()));
        }
        if (srcFileInfo.getHashInfo() != null) {
            destFileInfo.setHashInfo(new HashInfo((Map<String, String>)((Object)srcFileInfo.getHashInfo())));
        }
        destFileInfo.setFileAcl(srcFileInfo.getFileAcl());
        destFileInfo.setThFileAcl(srcFileInfo.getThFileAcl());
        destFileInfo.setCreateTime(new Date());
        return new SameCopyAspectChain(aspectList, (_srcfileInfo, _destFileInfo, _pre, _fileStorage, _fileRecorder) -> {
            _fileStorage.sameCopy(_srcfileInfo, _destFileInfo, _pre);
            _fileRecorder.save(_destFileInfo);
            return _destFileInfo;
        }).next(srcFileInfo, destFileInfo, pre, fileStorage, fileRecorder);
    }

    protected FileInfo crossCopy(FileInfo srcFileInfo, CopyPretreatment pre, FileStorage fileStorage, FileRecorder fileRecorder, List<FileStorageAspect> aspectList) {
        byte[] thBytes = StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename()) ? new Downloader(srcFileInfo, aspectList, fileStorage, 2).bytes() : null;
        FileInfo[] destFileInfoArr = new FileInfo[1];
        new Downloader(srcFileInfo, aspectList, fileStorage, 1).inputStream(in -> {
            String thumbnailSuffix = FileNameUtil.extName((String)pre.getThFilename());
            if (StrUtil.isNotBlank((CharSequence)thumbnailSuffix)) {
                thumbnailSuffix = "." + thumbnailSuffix;
            }
            destFileInfoArr[0] = ((UploadPretreatment)((UploadPretreatment)((UploadPretreatment)((UploadPretreatment)((UploadPretreatment)this.fileStorageService.of(in, srcFileInfo.getOriginalFilename(), srcFileInfo.getContentType(), srcFileInfo.getSize()).setPlatform(pre.getPlatform()).setPath(pre.getPath()).setSaveFilename(pre.getFilename()).setContentType(srcFileInfo.getContentType()).setSaveThFilename(thBytes != null, FileNameUtil.mainName((String)pre.getThFilename())).setThumbnailSuffix(thBytes != null, thumbnailSuffix).thumbnailOf(thBytes != null, thBytes).setThContentType(srcFileInfo.getThContentType()).setObjectType(srcFileInfo.getObjectType()).setObjectId(srcFileInfo.getObjectId()).setNotSupportAclThrowException(pre.getNotSupportAclThrowException() != null, pre.getNotSupportAclThrowException()).setFileAcl(srcFileInfo.getFileAcl() != null, srcFileInfo.getFileAcl()).setThFileAcl(srcFileInfo.getThFileAcl() != null, srcFileInfo.getThFileAcl()).setNotSupportMetadataThrowException(pre.getNotSupportMetadataThrowException() != null, pre.getNotSupportMetadataThrowException()).putMetadataAll(srcFileInfo.getMetadata() != null, (Map)srcFileInfo.getMetadata())).putThMetadataAll(srcFileInfo.getThMetadata() != null, (Map)srcFileInfo.getThMetadata())).putUserMetadataAll(srcFileInfo.getMetadata() != null, (Map)srcFileInfo.getUserMetadata())).putThUserMetadataAll(srcFileInfo.getThUserMetadata() != null, (Map)srcFileInfo.getThUserMetadata())).setProgressListener(pre.getProgressListener()).putAttrAll(srcFileInfo.getAttr() != null, (Map)srcFileInfo.getAttr())).upload((FileStorage)this.fileStorageService.getFileStorageVerify(pre.getPlatform()), fileRecorder, aspectList);
        });
        return destFileInfoArr[0];
    }
}

