/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.aspect;

import java.util.Iterator;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.SameMoveAspectChainCallback;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;

public class SameMoveAspectChain {
    private SameMoveAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public SameMoveAspectChain(Iterable<FileStorageAspect> aspects, SameMoveAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public FileInfo next(FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre, FileStorage fileStorage, FileRecorder fileRecorder) {
        if (this.aspectIterator.hasNext()) {
            return this.aspectIterator.next().sameMoveAround(this, srcFileInfo, destFileInfo, pre, fileStorage, fileRecorder);
        }
        return this.callback.run(srcFileInfo, destFileInfo, pre, fileStorage, fileRecorder);
    }

    public SameMoveAspectChainCallback getCallback() {
        return this.callback;
    }

    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    public void setCallback(SameMoveAspectChainCallback callback) {
        this.callback = callback;
    }

    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

