/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.surefire.api.util.ScannerFilter;
import org.apache.maven.surefire.shared.utils.io.SelectorUtils;

public class SpecificTestClassFilter
implements ScannerFilter {
    private static final char FS = System.getProperty("file.separator").charAt(0);
    private static final String JAVA_CLASS_FILE_EXTENSION = ".class";
    private Set<String> names;

    public SpecificTestClassFilter(String[] classNames) {
        if (classNames != null && classNames.length > 0) {
            this.names = new HashSet<String>();
            Collections.addAll(this.names, classNames);
        }
    }

    @Override
    public boolean accept(Class testClass) {
        boolean result = true;
        if (this.names != null && !this.names.isEmpty()) {
            String className = testClass.getName().replace('.', FS) + JAVA_CLASS_FILE_EXTENSION;
            boolean found = false;
            for (String pattern : this.names) {
                if ('\\' == FS) {
                    pattern = pattern.replace('/', FS);
                }
                if (!SelectorUtils.matchPath((String)pattern, (String)className, (boolean)true)) continue;
                found = true;
                break;
            }
            if (!found) {
                result = false;
            }
        }
        return result;
    }
}

