/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.StringMatcher;

public class VariableStringMatcher
extends StringMatcher {
    private final char[] allowedCharacters;
    private final char[] disallowedCharacters;
    private final int minimumLength;
    private final int maximumLength;
    private final StringMatcher nextMatcher;
    private String string;
    private int matchingBeginOffset;
    private int matchingEndOffset;
    private String matchingString;

    public VariableStringMatcher(char[] allowedCharacters, char[] disallowedCharacters, int minimumLength, int maximumLength, StringMatcher nextMatcher) {
        this.allowedCharacters = allowedCharacters;
        this.disallowedCharacters = disallowedCharacters;
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.nextMatcher = nextMatcher;
    }

    public String getMatchingString() {
        if (this.string == null) {
            throw new UnsupportedOperationException("Can't handle regular expression with referenced wildcard");
        }
        return this.matchingString == null ? (this.matchingString = this.string.substring(this.matchingBeginOffset, this.matchingEndOffset)) : this.matchingString;
    }

    protected boolean matches(String string, int beginOffset, int endOffset) {
        int length = endOffset - beginOffset;
        if (this.nextMatcher == null) {
            boolean match;
            boolean bl = match = length >= this.minimumLength && length <= this.maximumLength && this.areAllowedCharacters(string, beginOffset, endOffset);
            if (match) {
                this.rememberMatchingString(string, beginOffset, endOffset);
            } else {
                this.resetMatchingString();
            }
            return match;
        }
        if (length < this.minimumLength || !this.areAllowedCharacters(string, beginOffset, beginOffset + this.minimumLength)) {
            this.resetMatchingString();
            return false;
        }
        int maximumLength = Math.min(this.maximumLength, length);
        for (int index = this.minimumLength; index < maximumLength; ++index) {
            int offset = beginOffset + index;
            if (this.matchesNextMatcher(string, beginOffset, offset, endOffset)) {
                return true;
            }
            if (this.isAllowedCharacter(string.charAt(offset))) continue;
            this.resetMatchingString();
            return false;
        }
        int offset = beginOffset + maximumLength;
        if (this.matchesNextMatcher(string, beginOffset, offset, endOffset)) {
            return true;
        }
        this.resetMatchingString();
        return false;
    }

    private boolean areAllowedCharacters(String string, int beginOffset, int endOffset) {
        for (int offset = beginOffset; offset < endOffset; ++offset) {
            if (this.isAllowedCharacter(string.charAt(offset))) continue;
            return false;
        }
        return true;
    }

    private boolean isAllowedCharacter(char character) {
        if (this.allowedCharacters != null) {
            for (int index = 0; index < this.allowedCharacters.length; ++index) {
                if (this.allowedCharacters[index] != character) continue;
                return true;
            }
            return false;
        }
        if (this.disallowedCharacters != null) {
            for (int index = 0; index < this.disallowedCharacters.length; ++index) {
                if (this.disallowedCharacters[index] != character) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matchesNextMatcher(String string, int beginOffset, int splitOffset, int endOffset) {
        this.rememberMatchingString(string, beginOffset, splitOffset);
        return this.nextMatcher.matches(string, splitOffset, endOffset);
    }

    private void rememberMatchingString(String string, int matchingBeginOffset, int matchingEndOffset) {
        this.string = string;
        this.matchingBeginOffset = matchingBeginOffset;
        this.matchingEndOffset = matchingEndOffset;
        this.matchingString = null;
    }

    private void resetMatchingString() {
        this.string = null;
        this.matchingBeginOffset = 0;
        this.matchingEndOffset = 0;
        this.matchingString = null;
    }
}

