/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle.warmup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.inject.TypeLiteral;
import com.netflix.governator.annotations.WarmUp;
import com.netflix.governator.lifecycle.LifecycleMethods;
import com.netflix.governator.lifecycle.warmup.DependencyNode;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DAGManager {
    private final Map<Object, Object> keyToObject = Maps.newHashMap();
    private final Map<Object, LifecycleMethods> keyToLifecycle = Maps.newHashMap();
    private final Multimap<Object, Object> dependencies = ArrayListMultimap.create();
    private final Set<Object> nonRoots = Sets.newHashSet();
    private static final Object ROOT_DEPENDENCY_KEY = new Object();

    public synchronized DAGManager newCopyAndClear() {
        DAGManager copy = new DAGManager();
        copy.keyToObject.putAll(this.keyToObject);
        copy.keyToLifecycle.putAll(this.keyToLifecycle);
        copy.nonRoots.addAll(this.nonRoots);
        for (Object key : this.dependencies.keySet()) {
            ArrayList objectsCopy = Lists.newArrayList((Iterable)this.dependencies.get(key));
            copy.dependencies.putAll(key, (Iterable)objectsCopy);
        }
        this.clear();
        return copy;
    }

    public synchronized void addObjectMapping(Object objectKey, Object object, LifecycleMethods methods) {
        this.keyToObject.put(objectKey, object);
        this.keyToLifecycle.put(objectKey, methods);
        this.dependencies.put(objectKey, ROOT_DEPENDENCY_KEY);
    }

    public synchronized void addDependency(Object objectKey, Object dependencyKey) {
        this.dependencies.put(objectKey, dependencyKey);
        this.nonRoots.add(dependencyKey);
    }

    public synchronized DependencyNode buildTree() {
        this.processDependencies();
        return this.generateTree();
    }

    public synchronized Object getObject(Object key) {
        return this.keyToObject.get(key);
    }

    public synchronized LifecycleMethods getLifecycleMethods(Object key) {
        return this.keyToLifecycle.get(key);
    }

    public synchronized void clear() {
        this.keyToObject.clear();
        this.keyToLifecycle.clear();
        this.dependencies.clear();
    }

    @VisibleForTesting
    DependencyNode generateTree() {
        DependencyNode root = new DependencyNode(new Object());
        for (Object objectKey : this.dependencies.keySet()) {
            DependencyNode node = this.internalBuildTree(null, objectKey);
            if (this.nonRoots.contains(objectKey)) continue;
            root.addChild(node);
        }
        Preconditions.checkState((root.getChildren().size() > 0 || this.dependencies.size() == 0 ? 1 : 0) != 0, (Object)"No root objects found. Maybe there are circular dependencies.");
        return root;
    }

    private DependencyNode internalBuildTree(DependencyNode parent, Object objectKey) {
        DependencyNode node = new DependencyNode(objectKey);
        if (parent != null) {
            parent.addChild(node);
        }
        for (Object key : this.dependencies.get(objectKey)) {
            this.internalBuildTree(node, key);
        }
        return node;
    }

    private void processDependencies() {
        this.addImplicitDependencies();
        this.removeNonWarmUpDependencies();
        this.checkForCircularDependencies();
    }

    private void addImplicitDependencies() {
        HashSet objects = Sets.newHashSet();
        objects.addAll(this.dependencies.keySet());
        objects.addAll(this.dependencies.values());
        Set pairs = Sets.cartesianProduct((Set[])new Set[]{objects, objects});
        for (List pair : pairs) {
            this.addImplicitDependency(pair.get(0), pair.get(1));
        }
    }

    private void addImplicitDependency(Object parent, Object child) {
        if (parent instanceof TypeLiteral && child instanceof TypeLiteral && !parent.equals(child)) {
            TypeLiteral parentType = (TypeLiteral)parent;
            TypeLiteral childType = (TypeLiteral)child;
            if (TypeToken.of((Type)parentType.getType()).isAssignableFrom(childType.getType())) {
                this.dependencies.put(parent, child);
            }
        }
    }

    private void removeNonWarmUpDependencies() {
        Iterator it = this.dependencies.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (this.hasWarmUpMethod(key) || !this.extractDependency(key)) continue;
            it.remove();
        }
        it = this.dependencies.values().iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if ((this.hasWarmUpMethod(value) || ROOT_DEPENDENCY_KEY == value) && !this.dependencies.get(value).contains(value)) continue;
            it.remove();
        }
    }

    private boolean extractDependency(Object key) {
        boolean dependenciesPreserved = false;
        Collection values = this.dependencies.get(key);
        for (Map.Entry entry : this.dependencies.asMap().entrySet()) {
            if (!((Collection)entry.getValue()).contains(key)) continue;
            dependenciesPreserved = true;
            ((Collection)entry.getValue()).addAll(values);
        }
        return dependenciesPreserved;
    }

    private boolean hasWarmUpMethod(Object bridge) {
        LifecycleMethods lifecycleMethods = this.keyToLifecycle.get(bridge);
        return null != lifecycleMethods && !lifecycleMethods.methodsFor(WarmUp.class).isEmpty();
    }

    private void checkForCircularDependencies() {
        HashSet couldBeCircular = Sets.newHashSet((Iterable)this.dependencies.keySet());
        couldBeCircular.retainAll(this.dependencies.values());
        this.checkForCircularDependencies(Sets.newLinkedHashSet(), couldBeCircular);
    }

    private void checkForCircularDependencies(Set<Object> seen, Collection<Object> objects) {
        for (Object object : objects) {
            if (!seen.add(object) && this.hasWarmUpMethod(object)) {
                throw new IllegalStateException("Circular dependency detected: " + seen + " -> " + object);
            }
            this.checkForCircularDependencies(seen, this.dependencies.get(object));
            seen.remove(object);
        }
    }
}

