/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.base.Preconditions;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.lifecycle.ClasspathScanner;

public class LoadersBootstrapModule
implements BootstrapModule {
    private ClasspathScanner scanner;

    public LoadersBootstrapModule(ClasspathScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public void configure(BootstrapBinder binder) {
        for (Class<?> clazz : this.scanner.getClasses()) {
            if (!clazz.isAnnotationPresent(AutoBindSingleton.class) || !ConfigurationProvider.class.isAssignableFrom(clazz)) continue;
            AutoBindSingleton annotation = clazz.getAnnotation(AutoBindSingleton.class);
            Preconditions.checkState((annotation.value() == AutoBindSingleton.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for ConfigurationProviders");
            Preconditions.checkState((annotation.baseClass() == AutoBindSingleton.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for ConfigurationProviders");
            Preconditions.checkState((!annotation.multiple() ? 1 : 0) != 0, (Object)"@AutoBindSingleton(multiple=true) value cannot be set for ConfigurationProviders");
            Class<?> configurationProviderClass = clazz;
            binder.bindConfigurationProvider().to(configurationProviderClass).asEagerSingleton();
        }
    }
}

