/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms.httpclient;

import com.github.qcloudsms.httpclient.HTTPClient;
import com.github.qcloudsms.httpclient.HTTPRequest;
import com.github.qcloudsms.httpclient.HTTPResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class PoolingHTTPClient
implements HTTPClient {
    private PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
    private CloseableHttpClient client;

    public PoolingHTTPClient(int maxConnection) {
        this.connMgr.setMaxTotal(maxConnection);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connMgr).build();
    }

    public PoolingHTTPClient() {
        this(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse fetch(HTTPRequest request) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(request.url);
        for (Map.Entry<String, String> entry : request.parameters.entrySet()) {
            uriBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        RequestConfig reqConfig = RequestConfig.custom().setConnectTimeout(request.connectTimeout).setConnectionRequestTimeout(request.requestTimeout).build();
        RequestBuilder reqBuilder = RequestBuilder.create((String)request.method.name()).setUri(uriBuilder.build()).setEntity((HttpEntity)new ByteArrayEntity(request.body.getBytes(request.bodyCharset))).setConfig(reqConfig);
        for (Map.Entry<String, String> entry : request.headers.entrySet()) {
            reqBuilder.setHeader(entry.getKey(), entry.getValue());
        }
        HttpClientContext ctx = HttpClientContext.create();
        CloseableHttpResponse response = this.client.execute(reqBuilder.build(), (HttpContext)ctx);
        try {
            HTTPResponse res = new HTTPResponse().setRequest(request).setStatusCode(response.getStatusLine().getStatusCode()).setReason(response.getStatusLine().getReasonPhrase()).setBody(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            for (Header header : response.getAllHeaders()) {
                res.addHeader(header.getName(), header.getValue());
            }
            HTTPResponse hTTPResponse = res;
            return hTTPResponse;
        }
        finally {
            response.close();
        }
    }

    public synchronized void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.client = null;
        }
        if (this.connMgr != null) {
            this.connMgr.close();
            this.connMgr = null;
        }
    }
}

