/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsBase;
import com.github.qcloudsms.SmsMultiSenderResult;
import com.github.qcloudsms.SmsSenderUtil;
import com.github.qcloudsms.httpclient.DefaultHTTPClient;
import com.github.qcloudsms.httpclient.HTTPClient;
import com.github.qcloudsms.httpclient.HTTPException;
import com.github.qcloudsms.httpclient.HTTPMethod;
import com.github.qcloudsms.httpclient.HTTPRequest;
import com.github.qcloudsms.httpclient.HTTPResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmsMultiSender
extends SmsBase {
    private String url = "https://yun.tim.qq.com/v5/tlssmssvr/sendmultisms2";

    public SmsMultiSender(int appid, String appkey) {
        super(appid, appkey, new DefaultHTTPClient());
    }

    public SmsMultiSender(int appid, String appkey, HTTPClient httpclient) {
        super(appid, appkey, httpclient);
    }

    public SmsMultiSenderResult send(int type, String nationCode, ArrayList<String> phoneNumbers, String msg, String extend, String ext) throws HTTPException, JSONException, IOException {
        long random = SmsSenderUtil.getRandom();
        long now = SmsSenderUtil.getCurrentTime();
        JSONObject body = new JSONObject();
        body.put("tel", this.toTel(nationCode, phoneNumbers)).put("type", type).put("msg", (Object)msg).put("sig", (Object)SmsSenderUtil.calculateSignature(this.appkey, random, now, phoneNumbers)).put("time", now).put("extend", (Object)(SmsSenderUtil.isNotEmpty(extend) ? extend : "")).put("ext", (Object)(SmsSenderUtil.isNotEmpty(ext) ? ext : ""));
        HTTPRequest req = new HTTPRequest(HTTPMethod.POST, this.url).addHeader("Conetent-Type", "application/json").addQueryParameter("sdkappid", this.appid).addQueryParameter("random", random).setConnectionTimeout(60000).setRequestTimeout(60000).setBody(body.toString());
        try {
            HTTPResponse res = this.httpclient.fetch(req);
            this.handleError(res);
            return new SmsMultiSenderResult().parseFromHTTPResponse(res);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("API url has been modified, current url: " + this.url);
        }
    }

    public SmsMultiSenderResult send(int type, String nationCode, String[] phoneNumbers, String msg, String extend, String ext) throws HTTPException, JSONException, IOException {
        return this.send(type, nationCode, new ArrayList<String>(Arrays.asList(phoneNumbers)), msg, extend, ext);
    }

    public SmsMultiSenderResult sendWithParam(String nationCode, ArrayList<String> phoneNumbers, int templateId, ArrayList<String> params, String sign, String extend, String ext) throws HTTPException, JSONException, IOException {
        long random = SmsSenderUtil.getRandom();
        long now = SmsSenderUtil.getCurrentTime();
        JSONObject body = new JSONObject().put("tel", this.toTel(nationCode, phoneNumbers)).put("sign", (Object)sign).put("tpl_id", templateId).put("params", params).put("sig", (Object)SmsSenderUtil.calculateSignature(this.appkey, random, now, phoneNumbers)).put("time", now).put("extend", (Object)(SmsSenderUtil.isNotEmpty(extend) ? extend : "")).put("ext", (Object)(SmsSenderUtil.isNotEmpty(ext) ? ext : ""));
        HTTPRequest req = new HTTPRequest(HTTPMethod.POST, this.url).addHeader("Conetent-Type", "application/json").addQueryParameter("sdkappid", this.appid).addQueryParameter("random", random).setConnectionTimeout(60000).setRequestTimeout(60000).setBody(body.toString());
        try {
            HTTPResponse res = this.httpclient.fetch(req);
            this.handleError(res);
            return new SmsMultiSenderResult().parseFromHTTPResponse(res);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("API url has been modified, current url: " + this.url);
        }
    }

    public SmsMultiSenderResult sendWithParam(String nationCode, String[] phoneNumbers, int templateId, String[] params, String sign, String extend, String ext) throws HTTPException, JSONException, IOException {
        return this.sendWithParam(nationCode, new ArrayList<String>(Arrays.asList(phoneNumbers)), templateId, new ArrayList<String>(Arrays.asList(params)), sign, extend, ext);
    }

    private ArrayList<JSONObject> toTel(String nationCode, ArrayList<String> phoneNumbers) {
        ArrayList<JSONObject> phones = new ArrayList<JSONObject>();
        for (String phoneNumber : phoneNumbers) {
            JSONObject phone = new JSONObject();
            phone.put("nationcode", (Object)nationCode);
            phone.put("mobile", (Object)phoneNumber);
            phones.add(phone);
        }
        return phones;
    }
}

