/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Transaction;
import com.braintreegateway.UsBankAccount;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.util.Calendar;

public class UsBankAccountVerification {
    private String id;
    private Status status;
    private VerificationMethod verificationMethod;
    private String processorResponseCode;
    private String processorResponseText;
    private Calendar verificationDeterminedAt;
    private Calendar createdAt;
    private Transaction.GatewayRejectionReason gatewayRejectionReason;
    private UsBankAccount usBankAccount;

    public UsBankAccountVerification(NodeWrapper node) {
        this.id = node.findString("id");
        this.status = EnumUtils.findByName(Status.class, node.findString("status"), Status.UNRECOGNIZED);
        this.verificationMethod = EnumUtils.findByName(VerificationMethod.class, node.findString("verification-method"), VerificationMethod.UNRECOGNIZED);
        this.processorResponseCode = node.findString("processor-response-code");
        this.processorResponseText = node.findString("processor-response-text");
        this.createdAt = node.findDateTime("created-at");
        this.verificationDeterminedAt = node.findDateTime("verification-determined-at");
        this.gatewayRejectionReason = EnumUtils.findByName(Transaction.GatewayRejectionReason.class, node.findString("gateway-rejection-reason"), Transaction.GatewayRejectionReason.UNRECOGNIZED);
        NodeWrapper usBankAccountNode = node.findFirst("us-bank-account");
        if (usBankAccountNode != null) {
            this.usBankAccount = new UsBankAccount(usBankAccountNode);
        }
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public String getId() {
        return this.id;
    }

    public Transaction.GatewayRejectionReason getGatewayRejectionReason() {
        return this.gatewayRejectionReason;
    }

    public VerificationMethod getVerificationMethod() {
        return this.verificationMethod;
    }

    public Calendar getVerificationDeterminedAt() {
        return this.verificationDeterminedAt;
    }

    public String getProcessorResponseCode() {
        return this.processorResponseCode;
    }

    public String getProcessorResponseText() {
        return this.processorResponseText;
    }

    public Status getStatus() {
        return this.status;
    }

    public UsBankAccount getUsBankAccount() {
        return this.usBankAccount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerificationMethod {
        TOKENIZED_CHECK("tokenized_check"),
        NETWORK_CHECK("network_check"),
        INDEPENDENT_CHECK("independent_check"),
        UNRECOGNIZED("unrecognized"),
        MICRO_TRANSFERS("micro_transfers");

        private final String name;

        private VerificationMethod(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        FAILED("failed"),
        GATEWAY_REJECTED("gateway_rejected"),
        PROCESSOR_DECLINED("processor_declined"),
        UNRECOGNIZED("unrecognized"),
        VERIFIED("verified"),
        PENDING("pending");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

