/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.Configuration;
import com.braintreegateway.IdealPayment;
import com.braintreegateway.Result;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionRequest;
import com.braintreegateway.util.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdealPaymentGateway {
    private BraintreeGateway gateway;
    private Http http;
    private Configuration configuration;

    public IdealPaymentGateway(BraintreeGateway gateway, Http http, Configuration configuration) {
        this.gateway = gateway;
        this.http = http;
        this.configuration = configuration;
    }

    public IdealPayment find(String idealPaymentId) {
        return new IdealPayment(this.http.get(this.configuration.getMerchantPath() + "/ideal_payments/" + idealPaymentId));
    }

    public Result<Transaction> sale(String idealPaymentId, TransactionRequest transactionRequest) {
        transactionRequest.paymentMethodNonce(idealPaymentId).options().submitForSettlement(true);
        return this.gateway.transaction().sale(transactionRequest);
    }
}

