/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.autoconfigure;

import com.alibaba.cloud.dubbo.metadata.DubboProtocolConfigSupplier;
import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.metadata.repository.RandomServiceInstanceSelector;
import com.alibaba.cloud.dubbo.metadata.repository.ServiceInstanceSelector;
import com.alibaba.cloud.dubbo.metadata.resolver.DubboServiceBeanMetadataResolver;
import com.alibaba.cloud.dubbo.metadata.resolver.MetadataResolver;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceExporter;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceProxy;
import com.alibaba.cloud.dubbo.service.IntrospectiveDubboMetadataService;
import com.alibaba.cloud.dubbo.util.DubboMetadataUtils;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import feign.Contract;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.context.event.ServiceBeanExportedEvent;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;

@Configuration
@Import(value={DubboServiceMetadataRepository.class, IntrospectiveDubboMetadataService.class, DubboMetadataServiceExporter.class, JSONUtils.class, DubboMetadataServiceProxy.class, DubboMetadataUtils.class})
public class DubboMetadataAutoConfiguration {
    @Autowired
    private ObjectProvider<DubboServiceMetadataRepository> dubboServiceMetadataRepository;
    @Autowired
    private MetadataResolver metadataResolver;
    @Autowired
    private DubboMetadataServiceExporter dubboMetadataConfigServiceExporter;

    @Bean
    @ConditionalOnMissingBean
    public MetadataResolver metadataJsonResolver(ObjectProvider<Contract> contract) {
        return new DubboServiceBeanMetadataResolver(contract);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceInstanceSelector metadataServiceInstanceSelector() {
        return new RandomServiceInstanceSelector();
    }

    @Bean
    public Supplier<ProtocolConfig> dubboProtocolConfigSupplier(ObjectProvider<Collection<ProtocolConfig>> protocols) {
        return new DubboProtocolConfigSupplier(protocols);
    }

    @EventListener(value={ServiceBeanExportedEvent.class})
    public void onServiceBeanExported(ServiceBeanExportedEvent event) {
        ServiceBean serviceBean = event.getServiceBean();
        this.publishServiceRestMetadata(serviceBean);
    }

    @EventListener(value={ApplicationFailedEvent.class})
    public void onApplicationFailed() {
        this.unExportDubboMetadataConfigService();
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onContextClosed() {
        this.unExportDubboMetadataConfigService();
    }

    private void publishServiceRestMetadata(ServiceBean serviceBean) {
        ((DubboServiceMetadataRepository)this.dubboServiceMetadataRepository.getIfAvailable()).publishServiceRestMetadata(this.metadataResolver.resolveServiceRestMetadata(serviceBean));
    }

    private void unExportDubboMetadataConfigService() {
        this.dubboMetadataConfigServiceExporter.unexport();
    }
}

